% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_put_alarm}
\alias{lightsail_put_alarm}
\title{Creates or updates an alarm, and associates it with the specified metric}
\usage{
lightsail_put_alarm(
  alarmName,
  metricName,
  monitoredResourceName,
  comparisonOperator,
  threshold,
  evaluationPeriods,
  datapointsToAlarm = NULL,
  treatMissingData = NULL,
  contactProtocols = NULL,
  notificationTriggers = NULL,
  notificationEnabled = NULL
)
}
\arguments{
\item{alarmName}{[required] The name for the alarm. Specify the name of an existing alarm to update,
and overwrite the previous configuration of the alarm.}

\item{metricName}{[required] The name of the metric to associate with the alarm.

You can configure up to two alarms per metric.

The following metrics are available for each resource type:
\itemize{
\item \strong{Instances}: \code{BurstCapacityPercentage}, \code{BurstCapacityTime},
\code{CPUUtilization}, \code{NetworkIn}, \code{NetworkOut}, \code{StatusCheckFailed},
\code{StatusCheckFailed_Instance}, and \code{StatusCheckFailed_System}.
\item \strong{Load balancers}: \code{ClientTLSNegotiationErrorCount},
\code{HealthyHostCount}, \code{UnhealthyHostCount}, \code{HTTPCode_LB_4XX_Count},
\code{HTTPCode_LB_5XX_Count}, \code{HTTPCode_Instance_2XX_Count},
\code{HTTPCode_Instance_3XX_Count}, \code{HTTPCode_Instance_4XX_Count},
\code{HTTPCode_Instance_5XX_Count}, \code{InstanceResponseTime},
\code{RejectedConnectionCount}, and \code{RequestCount}.
\item \strong{Relational databases}: \code{CPUUtilization}, \code{DatabaseConnections},
\code{DiskQueueDepth}, \code{FreeStorageSpace}, \code{NetworkReceiveThroughput},
and \code{NetworkTransmitThroughput}.
}

For more information about these metrics, see \href{https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-resource-health-metrics.html#available-metrics}{Metrics available in Lightsail}.}

\item{monitoredResourceName}{[required] The name of the Lightsail resource that will be monitored.

Instances, load balancers, and relational databases are the only
Lightsail resources that can currently be monitored by alarms.}

\item{comparisonOperator}{[required] The arithmetic operation to use when comparing the specified statistic
to the threshold. The specified statistic value is used as the first
operand.}

\item{threshold}{[required] The value against which the specified statistic is compared.}

\item{evaluationPeriods}{[required] The number of most recent periods over which data is compared to the
specified threshold. If you are setting an "M out of N" alarm, this
value (\code{evaluationPeriods}) is the N.

If you are setting an alarm that requires that a number of consecutive
data points be breaching to trigger the alarm, this value specifies the
rolling period of time in which data points are evaluated.

Each evaluation period is five minutes long. For example, specify an
evaluation period of 24 to evaluate a metric over a rolling period of
two hours.

You can specify a minimum valuation period of 1 (5 minutes), and a
maximum evaluation period of 288 (24 hours).}

\item{datapointsToAlarm}{The number of data points that must be not within the specified
threshold to trigger the alarm. If you are setting an "M out of N"
alarm, this value (\code{datapointsToAlarm}) is the M.}

\item{treatMissingData}{Sets how this alarm will handle missing data points.

An alarm can treat missing data in the following ways:
\itemize{
\item \code{breaching} - Assume the missing data is not within the threshold.
Missing data counts towards the number of times the metric is not
within the threshold.
\item \code{notBreaching} - Assume the missing data is within the threshold.
Missing data does not count towards the number of times the metric
is not within the threshold.
\item \code{ignore} - Ignore the missing data. Maintains the current alarm
state.
\item \code{missing} - Missing data is treated as missing.
}

If \code{treatMissingData} is not specified, the default behavior of
\code{missing} is used.}

\item{contactProtocols}{The contact protocols to use for the alarm, such as \code{Email}, \code{SMS} (text
messaging), or both.

A notification is sent via the specified contact protocol if
notifications are enabled for the alarm, and when the alarm is
triggered.

A notification is not sent if a contact protocol is not specified, if
the specified contact protocol is not configured in the Amazon Web
Services Region, or if notifications are not enabled for the alarm using
the \code{notificationEnabled} paramater.

Use the \code{\link[=lightsail_create_contact_method]{create_contact_method}}
action to configure a contact protocol in an Amazon Web Services Region.}

\item{notificationTriggers}{The alarm states that trigger a notification.

An alarm has the following possible states:
\itemize{
\item \code{ALARM} - The metric is outside of the defined threshold.
\item \code{INSUFFICIENT_DATA} - The alarm has just started, the metric is not
available, or not enough data is available for the metric to
determine the alarm state.
\item \code{OK} - The metric is within the defined threshold.
}

When you specify a notification trigger, the \code{ALARM} state must be
specified. The \code{INSUFFICIENT_DATA} and \code{OK} states can be specified in
addition to the \code{ALARM} state.
\itemize{
\item If you specify \code{OK} as an alarm trigger, a notification is sent when
the alarm switches from an \code{ALARM} or \code{INSUFFICIENT_DATA} alarm
state to an \code{OK} state. This can be thought of as an \emph{all clear}
alarm notification.
\item If you specify \code{INSUFFICIENT_DATA} as the alarm trigger, a
notification is sent when the alarm switches from an \code{OK} or \code{ALARM}
alarm state to an \code{INSUFFICIENT_DATA} state.
}

The notification trigger defaults to \code{ALARM} if you don't specify this
parameter.}

\item{notificationEnabled}{Indicates whether the alarm is enabled.

Notifications are enabled by default if you don't specify this
parameter.}
}
\description{
Creates or updates an alarm, and associates it with the specified metric.

See \url{https://www.paws-r-sdk.com/docs/lightsail_put_alarm/} for full documentation.
}
\keyword{internal}
