% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gluedatabrew_operations.R
\name{gluedatabrew_update_recipe_job}
\alias{gluedatabrew_update_recipe_job}
\title{Modifies the definition of an existing DataBrew recipe job}
\usage{
gluedatabrew_update_recipe_job(
  EncryptionKeyArn = NULL,
  EncryptionMode = NULL,
  Name,
  LogSubscription = NULL,
  MaxCapacity = NULL,
  MaxRetries = NULL,
  Outputs = NULL,
  DataCatalogOutputs = NULL,
  DatabaseOutputs = NULL,
  RoleArn,
  Timeout = NULL
)
}
\arguments{
\item{EncryptionKeyArn}{The Amazon Resource Name (ARN) of an encryption key that is used to
protect the job.}

\item{EncryptionMode}{The encryption mode for the job, which can be one of the following:
\itemize{
\item \code{SSE-KMS} - Server-side encryption with keys managed by KMS.
\item \code{SSE-S3} - Server-side encryption with keys managed by Amazon S3.
}}

\item{Name}{[required] The name of the job to update.}

\item{LogSubscription}{Enables or disables Amazon CloudWatch logging for the job. If logging is
enabled, CloudWatch writes one log stream for each job run.}

\item{MaxCapacity}{The maximum number of nodes that DataBrew can consume when the job
processes data.}

\item{MaxRetries}{The maximum number of times to retry the job after a job run fails.}

\item{Outputs}{One or more artifacts that represent the output from running the job.}

\item{DataCatalogOutputs}{One or more artifacts that represent the Glue Data Catalog output from
running the job.}

\item{DatabaseOutputs}{Represents a list of JDBC database output objects which defines the
output destination for a DataBrew recipe job to write into.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the Identity and Access Management
(IAM) role to be assumed when DataBrew runs the job.}

\item{Timeout}{The job's timeout in minutes. A job that attempts to run longer than
this timeout period ends with a status of \code{TIMEOUT}.}
}
\description{
Modifies the definition of an existing DataBrew recipe job.

See \url{https://www.paws-r-sdk.com/docs/gluedatabrew_update_recipe_job/} for full documentation.
}
\keyword{internal}
