% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_region_series.R
\name{sample_region_series}
\alias{sample_region_series}
\title{Sample points from a region time series}
\usage{
sample_region_series(x, size, method = "random", replace = FALSE, na.rm = TRUE)
}
\arguments{
\item{x}{a \code{\link[terra:SpatRaster-class]{terra::SpatRasterDataset}} returned by \code{\link[=region_series]{region_series()}}}

\item{size}{number of points sampled. A single value is used to sample the
same locations across all time steps, a vector of values to sample
different locations at each time step.}

\item{method}{one of the sampling methods from \code{\link[terra:sample]{terra::spatSample()}}. It
defaults to "random"}

\item{replace}{boolean determining whether we sample with replacement}

\item{na.rm}{boolean determining whether NAs are removed}
}
\value{
a data.frame with the sampled cells and their respective values for
the climate variables.
}
\description{
This function samples points from a region time series. Sampling can either
be performed for the same locations at all time steps (if only one value is
given for \code{size}), or for different locations for each time step (if \code{size}
is a vector of length equal to the number of time steps). To sample the same
number of points, but different locations, for each time step, provide a
vector repeating the same value for each time step.
}
\details{
This function wraps \code{\link[terra:sample]{terra::spatSample()}} to appropriate sample the
\code{\link[terra:SpatRaster-class]{terra::SpatRaster}}s in the \code{\link[terra:SpatRaster-class]{terra::SpatRasterDataset}} returned by
\code{\link[=region_series]{region_series()}}.
}
