% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_node.R
\name{rmd_node_utilities}
\alias{rmd_node_utilities}
\alias{rmd_node_label}
\alias{rmd_node_label<-}
\alias{rmd_node_label<-.default}
\alias{rmd_node_label<-.rmd_chunk}
\alias{rmd_node_type}
\alias{rmd_node_length}
\alias{rmd_node_content}
\alias{rmd_node_attr}
\alias{rmd_node_engine}
\alias{rmd_node_options}
\alias{rmd_node_code}
\alias{rmd_node_options<-}
\alias{rmd_node_options<-.default}
\alias{rmd_node_options<-.rmd_chunk}
\alias{rmd_node_attr<-}
\alias{rmd_node_attr<-.default}
\alias{rmd_node_attr<-.rmd_node}
\alias{rmd_node_content<-}
\alias{rmd_node_content<-.default}
\alias{rmd_node_content<-.rmd_chunk}
\alias{rmd_node_content<-.rmd_raw_chunk}
\alias{rmd_node_content<-.rmd_markdown}
\alias{rmd_node_content<-.rmd_code_block}
\alias{rmd_node_content<-.rmd_code_block_literal}
\alias{rmd_node_set_label}
\alias{rmd_node_set_options}
\alias{rmd_node_set_content}
\alias{rmd_node_set_attr}
\title{rmd node utility functions}
\usage{
rmd_node_label(x)

rmd_node_label(x) <- value

\method{rmd_node_label}{default}(x) <- value

\method{rmd_node_label}{rmd_chunk}(x) <- value

rmd_node_type(x)

rmd_node_length(x)

rmd_node_content(x)

rmd_node_attr(x, attr)

rmd_node_engine(x)

rmd_node_options(x, yaml_style = TRUE)

rmd_node_code(x)

rmd_node_options(x) <- value

\method{rmd_node_options}{default}(x) <- value

\method{rmd_node_options}{rmd_chunk}(x) <- value

rmd_node_attr(x, attr) <- value

\method{rmd_node_attr}{default}(x, attr) <- value

\method{rmd_node_attr}{rmd_node}(x, attr) <- value

rmd_node_content(x) <- value

\method{rmd_node_content}{default}(x) <- value

\method{rmd_node_content}{rmd_chunk}(x) <- value

\method{rmd_node_content}{rmd_raw_chunk}(x) <- value

\method{rmd_node_content}{rmd_markdown}(x) <- value

\method{rmd_node_content}{rmd_code_block}(x) <- value

\method{rmd_node_content}{rmd_code_block_literal}(x) <- value

rmd_node_set_label(x, value)

rmd_node_set_options(x, ...)

rmd_node_set_content(x, value)

rmd_node_set_attr(x, attr, value)
}
\arguments{
\item{x}{An rmd object, e.g. \code{rmd_ast} or \code{rmd_tibble}.}

\item{value}{The new value to assign (for assignment functions).}

\item{attr}{Attribute name to extract or set.}

\item{yaml_style}{logical, if \code{TRUE} (default) return option names in YAML style (with hyphens), if \code{FALSE} return normalized style (with dots)}

\item{...}{For \code{rmd_node_set_options()}, named arguments that will be converted to a list of options to assign.}
}
\value{
\itemize{
\item \code{rmd_node_label()} - returns a character vector of node labels,
nodes without labels return \code{NA}.
\item \verb{rmd_node_label<-()} - assigns new labels to chunk nodes. For the setter, returns the modified object.
\item \code{rmd_node_type()} - returns a character vector of node types.
\item \code{rmd_node_length()} - returns an integer vector of node lengths (i.e. lines of code, lines of text, etc.),
nodes without a length return \code{NA}.
\item \code{rmd_node_content()} - returns the raw character vector(s) of node textual content (lines/code), nodes without content return \code{NULL}.
\item \code{rmd_node_attr()} - returns the value of a given node attribute (S7 property), returns \code{NULL} if the attribute does not exist.
\item \code{rmd_node_engine()} - returns a character vector of chunk engines,
\code{NA} for all other node types.
\item \code{rmd_node_options()} - returns a list of chunk node options (named list), \code{NULL} for all other node types. Option names are returned in YAML style (with hyphens) by default, or normalized style (with dots) if \code{yaml_style = FALSE}.
\item \verb{rmd_node_options<-()} - assigns new options to chunk nodes by merging with existing options. Takes a named list of options. For the setter, returns the modified object.
\item \verb{rmd_node_attr<-()} - assigns new attribute values to nodes. For the setter, returns the modified object.
\item \code{rmd_node_code()} - returns a list of chunk node code (character vector),
\code{NULL} for all other node types.
\item \code{rmd_node_set_label()} - pipeable version of \verb{rmd_node_label<-()} for setting node labels.
\item \code{rmd_node_set_options()} - pipeable version of \verb{rmd_node_options<-()} for setting chunk options.
\item \code{rmd_node_set_attr()} - pipeable version of \verb{rmd_node_attr<-()} for setting node attributes.
\item \verb{rmd_node_content<-()} - assigns new content to nodes. For the setter, returns the modified object.
\item \code{rmd_node_set_content()} - pipeable version of \verb{rmd_node_content<-()} for setting node content.
}
}
\description{
Functions for extracting information for Rmd nodes.
}
\examples{

rmd = parse_rmd(system.file("examples/hw01.Rmd", package="parsermd"))

rmd_node_label(rmd)
rmd_node_type(rmd)
rmd_node_content(rmd)
rmd_node_attr(rmd, "level")
rmd_node_engine(rmd)
rmd_node_options(rmd)
rmd_node_code(rmd)

chunk = rmd_chunk("r", "example", code = "1 + 1")
rmd_node_label(chunk)
rmd_node_label(chunk) = "new_name"
rmd_node_label(chunk)

rmd_node_options(chunk) = list(eval = FALSE, echo = TRUE)
rmd_node_options(chunk)

rmd_node_attr(chunk, "engine") = "python"
rmd_node_attr(chunk, "engine")

rmd_node_content(chunk) = c("x = 2", "y = 3")
rmd_node_content(chunk)

chunk = rmd_chunk("r", "example", code = "1 + 1") |>
  rmd_node_set_label("new_label") |>
  rmd_node_set_options(eval = FALSE, echo = TRUE) |>
  rmd_node_set_content(c("a = 1", "b = 2"))

rmd_node_label(chunk)
rmd_node_options(chunk)
rmd_node_options(chunk, yaml_style = FALSE)  # get in normalized style
rmd_node_content(chunk)

chunk = rmd_chunk("r", "example", code = "x = 1") |>
  rmd_node_set_attr("engine", "python")

rmd_node_engine(chunk)

}
