% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_insert.R
\name{rmd_insert}
\alias{rmd_insert}
\title{Insert nodes at specified locations}
\usage{
rmd_insert(
  x,
  ...,
  nodes,
  location = c("before", "after"),
  allow_multiple = FALSE
)
}
\arguments{
\item{x}{Rmd object, e.g. \code{rmd_ast} or \code{rmd_tibble}, to insert the nodes.}

\item{...}{One or more unquoted expressions separated by commas for node selection.
Uses the same syntax as \code{\link[=rmd_select]{rmd_select()}}.}

\item{nodes}{Nodes to insert. Can be a single rmd node object, a list of rmd node
objects, or an \code{rmd_ast} object.}

\item{location}{Character. Either "before" or "after" to specify where to insert
relative to the selected nodes. "before" inserts before the first node of each
selected range, "after" inserts after the last node of each selected range.}

\item{allow_multiple}{Logical. If \code{FALSE} (default), throws an error when
selected indices are discontinuous. If \code{TRUE}, allows inserting at multiple
discontinuous locations.}
}
\value{
Returns the modified Rmd object with nodes inserted at the specified locations.
}
\description{
This function inserts nodes into an \code{rmd_ast} at specified locations
relative to selected nodes. The selection is implemented using the same approach
as \code{\link[=rmd_select]{rmd_select()}} which enables a variety of useful syntax for selecting nodes.

The function checks if the selected indices form continuous ranges and can either
insert before or after that range. \code{allow_multiple} parameter can be used to allow
insertion based on multiple discontinuous ranges.
}
\examples{
rmd = parse_rmd(system.file("examples/hw01.Rmd", package = "parsermd"))

new_nodes = list(
  rmd_markdown(lines = "This is a comment"),
  rmd_chunk(engine = "r", code = "# New code")
)
rmd_insert(rmd, "plot-dino", nodes = new_nodes, location = "after")

new_heading = rmd_heading(name = "Analysis", level = 2L)
rmd_insert(rmd, has_type("rmd_chunk"), nodes = new_heading, 
           location = "before", allow_multiple = TRUE)

rmd_insert(rmd, c(1, 3, 5), 
  nodes = rmd_markdown(lines = "Separator"), 
  location = "after", 
  allow_multiple = TRUE)

}
