% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_leftovers.R
\name{get_leftovers}
\alias{get_leftovers}
\title{Retrieve source from beyond the end of the document.}
\usage{
get_leftovers(text, items = parseLatex(text))
}
\arguments{
\item{text}{Character vector holding source.}

\item{items}{Parsed version of \code{text}.}
}
\value{
The part of \code{text} that follows \verb{\\end\{document\}}
other than a single newline, named according to the
original line numbers.
}
\description{
Retrieve source from beyond the end of the document.
}
\note{
The line numbering in the output matches what a
text editor would see; embedded newlines in \code{text} will
result in separate lines in the output.
}
\examples{
# line:  1                  2                3
text <- "\\\\begin{document}\n\\\\end{document}\nnotes"
get_leftovers(text)
}
