% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvar_fe_ols.R
\name{pvarfeols}
\alias{pvarfeols}
\title{Fixed Effects Estimator for PVAR Model}
\usage{
pvarfeols(
  dependent_vars,
  lags,
  exog_vars,
  transformation = c("demean"),
  data,
  panel_identifier = c(1, 2)
)
}
\arguments{
\item{dependent_vars}{Dependent variables}

\item{lags}{Number of lags of dependent variables}

\item{exog_vars}{Exogenous variables}

\item{transformation}{Demeaning \code{"demean"}}

\item{data}{Data set}

\item{panel_identifier}{Vector of panel identifiers}
}
\description{
This function estimates a stationary PVAR with fixed effects.
}
\examples{
data(Cigar)
ex1_feols <-
pvarfeols(dependent_vars = c("log_sales", "log_price"),
          lags = 1,
          exog_vars = c("cpi"),
          transformation = "demean",
          data = Cigar,
          panel_identifier= c("state", "year"))
          
summary(ex1_feols)         
}
