% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{tree.ages.spp}
\alias{tree.ages.spp}
\title{Automatically build matrix for time-calibration of phylogenetic trees using occurrence data.}
\usage{
tree.ages.spp(phylo0, data)
}
\arguments{
\item{phylo0}{Either an object of class phylo, or a character vector containing taxon names for building the matrix}

\item{data}{A higher-level taxon name to get data for in the paleobiology database, or a data.frame containing a species table containing entries for the taxa in question.}
}
\value{
A two-column matrix containing earliest and latest occurrences for each taxon in taxa, with taxon names as row names
}
\description{
Automatically build matrix for time-calibration of phylogenetic trees using occurrence data.
}
\details{
tree.ages looks for the taxon names in the tna column of a taxon-range table (as produced by mk.sptab()), so it will only recover ages for taxa that can be found there. For a function optimized for higher-level taxa that might not be represented in such a table, see tree.ages().  It is highly recommended to manually inspect the resulting table for accuracy.
}
\examples{
data(archosauria)
data(tree_archosauria)
tree.ages.spp(tree_archosauria,data=archosauria$sptab_Ornithopoda)->ages
}
