% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{synonymize}
\alias{synonymize}
\title{Combine selected entries in a taxon-range table to remove duplicates}
\usage{
synonymize(x, table = NULL, ids = table$tna, max = table$max, min = table$min)
}
\arguments{
\item{x}{Indices or values (taxon names) to combine}

\item{table}{Taxon-range table}

\item{ids}{Vector or column of taxon names (used for matching taxon names in x). Defaults to table$tna}

\item{max}{Vector or column containing maximum ages}

\item{min}{Vector or column containing minimum ages}
}
\value{
A data.frame containing taxon names, maximum, minimum and mean ages, with ranges for the selected entries merged and superfluous entries removed (note that the first taxon indicated by x is kept as valid).
}
\description{
Combine selected entries in a taxon-range table to remove duplicates
}
\details{
This function is meant as an aid to manually editing species tables and remove synonyms or incorrect spellings of taxonomic name that result in an inflated number of distinct taxa being represented.
}
\examples{
data(archosauria)
sp<-archosauria$sptab_Stegosauria
synonymize(c(32,33),sp)->sp
synonymize(grep("stenops",sp$tna),sp)->sp
synonymize(c("Hesperosaurus mjosi","Stegosaurus mjosi"),sp)->sp
}
