% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pecv_miss.R
\name{generate_binary_data_miss}
\alias{generate_binary_data_miss}
\title{Generate binary data with missing values}
\usage{
generate_binary_data_miss(n = 100, p = 50, q = 3, miss_prop = 0.05)
}
\arguments{
\item{n}{Integer. Number of observations.}

\item{p}{Integer. Number of variables.}

\item{q}{Integer. True number of latent factors.}

\item{miss_prop}{Numeric in (0,1). Proportion of missing values (default 0.05).}
}
\value{
A named list with components:
\describe{
  \item{resp}{Binary matrix (n x p). Generated 0/1 responses with missing values (NA).}
  \item{resp_complete}{Binary matrix (n x p). Complete data before missingness.}
  \item{true_q}{Integer. True number of factors used in simulation.}
  \item{theta_true}{Numeric matrix. True latent factor scores.}
  \item{A_true}{Numeric matrix. True factor loadings.}
  \item{d_true}{Numeric vector (length p). Item intercepts.}
  \item{miss_prop}{Numeric. Proportion of entries set to missing.}
}
}
\description{
Generate simulated data from a binary (logistic) factor model with missing values.
}
