% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_assessment.R
\name{dataset_assessment}
\alias{dataset_assessment}
\title{Returns the formatted assessment data sets}
\usage{
dataset_assessment(
  module = c("All", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF", "GGG"),
  presentation = c("2013B", "2014B", "2013J", "2014J", "All", "Summer", "Winter"),
  repeat_students = c("remove", "keep"),
  week_begin = 1,
  week_end = 39,
  na.rm = FALSE
)
}
\arguments{
\item{module}{name of the module to be included, either \code{"All"}, \code{"AAA"}, \code{"BBB"}, \code{"CCC"}, \code{"DDD"}, \code{"EEE"}, \code{"FFF"} or \code{"GGG"}.}

\item{presentation}{name of the semester of the module to be included, either \code{"2013B"},
\code{"2014B"}, \code{"2013J"}, \code{"2014J"}, \code{"All"}, \code{"Summer"} or \code{"Winter"}.
\code{"B"} indicates a February start time whereas \code{"J"} indicates an October start time. \code{"All"} indicates
that all presentations of the module will be included in the returned data. Where possible, \code{"Summer"} returns both \code{"2013B"} and \code{"2014B"}, and
\code{"Winter"} returns both \code{"2013J"} and \code{"2014J"}.}

\item{repeat_students}{indicator of whether students who had previous attempts at the module should be removed, either \code{"remove"} or \code{"keep"}.}

\item{week_begin}{the first semester week of the assessment data to be included in formatted data.}

\item{week_end}{the last semester week of the assessment data to be included in the formatted data. To ensure all
continuous assessment is included regardless of the module presentation, set this to 39, the last week of data in the OULAD.}

\item{na.rm}{logical. Indicates whether NAs should be omitted from the average continuous assessment calculations
or treated as zeroes (default). This calculation only includes continuous assessment that
were due between the period set by \code{"week_begin"} and \code{"week_end"} inclusive,
and only occurs when a specific module presentation is requested (e.g., 'BBB 2013J').}
}
\value{
Returns four \code{tibbles} (objects of class \code{tbl_df}) based on the OULAD studentAssessment.csv and assessments.csv files
and the specified inputs (module, presentation, and repeat_students).
The four \code{tibbles} are: 1) assessment_data, 2) assessments, 3) assessment_performance, and 4) assessment_reactivity.
}
\description{
Load, combines and formats the assessment and student assessment data sets from the OULAD for data analysis.
}
\section{assessment_data tibble}{

A \code{tibble} based on the combined OULAD files of studentAssessment.csv and assessments.csv,
and the inputs. The \code{tibble} consists of (Kuzilek et al., 2017):

\itemize{
\item{id_student - unique student identification number.}
\item{code_module - module identification code.}
\item{code_presentation - module presentation identification code.}
\item{id_assessment - assessment identification number.}
\item{assessment_type - type of assessment.}
\item{date - information about the final submission date of the assessment calculated as the number of days since the start of the module-presentation.}
\item{weight - weight of the assessment in \%.}
\item{date_submitted - day of the assessment submission by student.}
\item{is_banked - logical indicator whether assessment result has been transferred from a previous presentation.}
\item{score - student’s score for the specific assessment (range 0-100).}
\item{reactivity - calculated using the date variable minus date_submitted variable.}
}
}

\section{assessments tibble}{

A \code{tibble} of seven columns which details for each assessment item for a module presentation,
the type of assessment it is, the due date and week of the assessment,
and the weight of the assessment. The assessment types are Tutor Marked Assessment (TMA), Computer Marked Assessment (CMA)
and Final Exam (Exam). Exams are generally treated separately to other assessments
and have weight equal to 100\%. The sum of all other assessments is also 100\% (Kuzilek et al., 2017).
}

\section{assessment_performance tibble}{

A \code{tibble} where each row represents a unique student and their scores in the range of 0-100
for different assessment items. When a specific module (not 'All') and presentation (not 'All' or 'Winter' or 'Summer') is selected,
the final column states each student's average continuous assessment score based on their continuous assessment
scores and the assessments weights. For this calculation, the NAs may be not included or replaced by 0 (default; see na.rm argument).
The average assessment score will not be calculated if the only variable outputted is exam score.
Not all module presentations have exam scores available.
Details of the assessment items can be seen in the assessments \code{tibble}.
}

\section{assessment_reactivity tibble}{

A \code{tibble} where each row represents a unique student and their reactivity for
different assessment items. Treuillier and Boyer (2021) define reactivity for the OULAD as the delay between
the date the assessment is returned and the deadline (in days). Negative numbers indicate overdue assessments.
Details of the assessment items can be seen in the assessments \code{tibble}.
}

\examples{
dataset_assessment(module = "BBB", presentation = "2013J",
repeat_students = "remove", week_begin = 1, week_end=39, na.rm = FALSE)
}
\references{
Treuillier, C., & Boyer, A. (2021). Identification of class-representative learner personas.
In LA4SLE 2021 - Learning Analytics for Smart Learning Environments (pp. 38-45). Bolzano, Italy.

Kuzilek, J., Hlosta, M., & Zdrahal, Z. (2017). Open university learning analytics dataset. Scientific Data
volume 4, (pp. 1–8). https://doi.org/10.1038/sdata.2017.171.
}
\seealso{
\code{\link[=combined_dataset]{combined_dataset()}}
}
