% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-network.R
\name{oe_get_network}
\alias{oe_get_network}
\title{Import transport networks used by a specific mode of transport}
\usage{
oe_get_network(place, mode = c("cycling", "driving", "walking"), ...)
}
\arguments{
\item{place}{Description of the geographical area that should be matched with
a \code{.osm.pbf} file. Can be either a length-1 character vector, an
\code{sf}/\code{sfc}/\code{bbox} object with any CRS, or a numeric vector of coordinates
with length 2. In the last case, it is assumed that the EPSG code is 4326
specified as c(LON, LAT), while you can use any CRS with \code{sf}/\code{sfc}/\code{bbox}
objects. See Details and Examples in \code{\link[=oe_match]{oe_match()}}.}

\item{mode}{A character string of length one denoting the desired mode of
transport. Can be abbreviated. Currently \code{cycling} (the default), \code{driving}
and \code{walking} are supported.}

\item{...}{Additional arguments passed to \code{\link[=oe_get]{oe_get()}} such as \code{boundary} or
\code{force_download}.}
}
\value{
An \code{sf} object.
}
\description{
This function is a wrapper around \code{\link[=oe_get]{oe_get()}} and can be used to import a road
network given a \code{place} and a mode of transport. Check the Details for a
precise description of the procedures used to filter the OSM ways according
to each each mode of transport.
}
\details{
The definition of usable transport network was taken from the Python
packages
\href{https://raw.githubusercontent.com/gboeing/osmnx/refs/heads/main/osmnx/_overpass.py}{osmnx} and
\href{https://pyrosm.readthedocs.io/en/latest/}{pyrosm} and several other
documents found online, i.e.
\url{https://wiki.openstreetmap.org/wiki/OSM_tags_for_routing/Access_restrictions},
\url{https://wiki.openstreetmap.org/wiki/Key:access}. See also the discussion
in \url{https://github.com/ropensci/osmextract/issues/153}.

The \code{cycling} mode of transport (i.e. the default value for \code{mode}
parameter) selects the OSM ways that meet the following conditions:
\itemize{
\item The \code{highway} tag is not missing;
\item The \code{highway} tag is not equal to \code{abandoned}, \code{bus_guideway}, \code{byway},
\code{construction}, \code{corridor}, \code{elevator}, \code{fixme}, \code{escalator}, \code{gallop},
\code{historic}, \code{no}, \code{planned}, \code{platform}, \code{proposed}, \code{raceway} or
\code{steps};
\item The \code{highway} tag is not equal to \code{motorway}, \code{motorway_link},
\code{footway}, \code{bridleway} or \code{pedestrian} unless the tag \code{bicycle} is equal
to \code{yes}, \code{designated}, \code{permissive} or \code{destination} (see
\href{https://wiki.openstreetmap.org/wiki/Bicycle#Bicycle_Restrictions}{here}
for more details);
\item The \code{access} tag is not equal to \code{private} or \code{no} unless \code{bicycle} is
equal to \code{yes}, \code{permissive} or \code{designated} (see #289);
\item The \code{bicycle} tag is not equal to \code{no}, \code{use_sidepath}, \code{private}, or
\code{restricted};
\item The \code{service} tag does not contain the string \code{private} (i.e.
\code{private}, \code{private_access} and similar);
}

The \code{walking} mode of transport selects the OSM ways that meet the
following conditions:
\itemize{
\item The \code{highway} tag is not missing;
\item The \code{highway} tag is not equal to \code{abandoned}, \code{bus_guideway},
\code{byway}, \code{construction}, \code{corridor}, \code{elevator}, \code{fixme},
\code{escalator}, \code{gallop}, \code{historic}, \code{no}, \code{planned}, \code{platform}, \code{proposed},
\code{raceway}, \code{motorway} or \code{motorway_link};
\item The \code{highway} tag is not equal to \code{cycleway} unless the \code{foot} tag is
equal to \code{yes};
\item The \code{access} tag is not equal to \code{private} or \code{no} unless \code{foot} is
equal to \code{yes}, \code{permissive}, or \code{designated} (see #289);
\item The \code{foot} tag is not equal to \code{no}, \code{use_sidepath}, \code{private}, or
\code{restricted};
\item The \code{service} tag does not contain the string \code{private}
(i.e. \code{private}, \code{private_access} and similar).
}

The \code{driving} mode of transport selects the OSM ways that meet the
following conditions:
\itemize{
\item The \code{highway} tag is not missing;
\item The \code{highway} tag is not equal to \code{abandoned},
\code{bus_guideway}, \code{byway}, \code{construction}, \code{corridor}, \code{elevator}, \code{fixme},
\code{escalator}, \code{gallop}, \code{historic}, \code{no}, \code{planned}, \code{platform}, \code{proposed},
\code{cycleway}, \code{pedestrian}, \code{bridleway}, \code{path}, or \code{footway};
\item The \code{access} tag is not equal to \code{private} or \code{no} unless \code{motor_vehicle} is
equal to \code{yes}, \code{permissive}, or \code{designated} (see #289);
\item The \code{service} tag does not contain the string \code{private} (i.e. \code{private},
\code{private_access} and similar).
}

Feel free to create a new issue in the \href{https://github.com/ropensci/osmextract}{github repo} if you want to suggest
modifications to the current filters or propose new values for alternative
modes of transport.

Starting from version 0.5.2, the \code{version} argument (see \code{\link[=oe_get]{oe_get()}}) can be
used to download historical OSM extracts from Geofabrik provider.
}
\examples{
# Copy the ITS file to tempdir() to make sure that the examples do not
# require internet connection. You can skip the next 4 lines (and start
# directly with oe_get_keys) when running the examples locally.

its_pbf = file.path(tempdir(), "test_its-example.osm.pbf")
file.copy(
  from = system.file("its-example.osm.pbf", package = "osmextract"),
  to = its_pbf,
  overwrite = TRUE
)

# default value returned by OSM
its = oe_get(
  "ITS Leeds", quiet = TRUE, download_directory = tempdir()
)
plot(its["highway"], lwd = 2, key.pos = 4, key.width = lcm(2.75))
# walking mode of transport
its_walking = oe_get_network(
  "ITS Leeds", mode = "walking",
  download_directory = tempdir(), quiet = TRUE
)
plot(its_walking["highway"], lwd = 2, key.pos = 4, key.width = lcm(2.75))
# driving mode of transport
its_driving = oe_get_network(
  "ITS Leeds", mode = "driving",
  download_directory = tempdir(), quiet = TRUE
)
plot(its_driving["highway"], lwd = 2, key.pos = 4, key.width = lcm(2.75))

# Remove .pbf and .gpkg files in tempdir
oe_clean(tempdir())
}
\seealso{
\code{\link[=oe_get]{oe_get()}}
}
