# ------------------------------------------------------------------------------
# Generated by 'build-pre/build.r': do not edit by hand.
# ------------------------------------------------------------------------------

#' @title Convenience geoms for row and column matrix factors
#' 
#' @description These geometric element layers (geoms) pair
#'   conventional **ggplot2** geoms with [stat_rows()] or
#'   [stat_cols()] in order to render elements for one or the other
#'   matrix factor of a tbl_ord. They understand the same aesthetics
#'   as their corresponding conventional geoms.
#' 
#' @name biplot-geoms
#' @template return-layer
#' @family biplot layers
#' @include layer-utils.r
#' @import ggplot2
#' @importFrom ggrepel
#'   GeomTextRepel
#'   GeomLabelRepel
#'   geom_text_repel
#'   geom_label_repel
#'   position_nudge_repel

#' @importFrom gggda
#'   GeomAxis
#'   GeomPointranges
#'   GeomLineranges
#'   GeomIsoline
#'   GeomTextRadiate
#'   GeomVector
#'   GeomBagplot
#'   GeomRule
#'   geom_axis
#'   geom_pointranges
#'   geom_lineranges
#'   geom_isoline
#'   geom_text_radiate
#'   geom_vector
#'   geom_bagplot
#'   geom_rule
#'   minpp
#'   maxpp
#'   minabspp
#' @inheritParams ggplot2::layer
#' @template param-geom
#' @inheritParams ggplot2::geom_point
#' @inheritParams ggplot2::geom_path
#' @inheritParams ggplot2::geom_polygon
#' @inheritParams ggplot2::geom_contour
#' @inheritParams ggplot2::geom_density_2d
#' @inheritParams ggplot2::geom_density_2d_filled
#' @inheritParams ggplot2::geom_text
#' @inheritParams ggplot2::geom_label
#' @inheritParams ggrepel::geom_text_repel
#' @inheritParams ggrepel::geom_label_repel
#' @inheritParams gggda::geom_axis
#' @inheritParams gggda::geom_pointranges
#' @inheritParams gggda::geom_lineranges
#' @inheritParams gggda::geom_isoline
#' @inheritParams gggda::geom_text_radiate
#' @inheritParams gggda::geom_vector
#' @inheritParams gggda::geom_bagplot
#' @inheritParams gggda::geom_rule
#' @inheritParams geom_interpolation
#' @example inst/examples/ex-geom-intervals-ord-glass.r
#' @example inst/examples/ex-geom-unit-circle-ord-glass.r
NULL

#' @export
ggrepel::geom_text_repel
#' @export
ggrepel::geom_label_repel
#' @export
gggda::geom_axis
#' @export
gggda::geom_pointranges
#' @export
gggda::geom_lineranges
#' @export
gggda::geom_isoline
#' @export
gggda::geom_text_radiate
#' @export
gggda::geom_vector
#' @export
gggda::geom_bagplot
#' @export
gggda::geom_rule

compute_just <- getFromNamespace("compute_just", "ggplot2")
to_unit <- getFromNamespace("to_unit", "ggrepel")

#' @export
ggrepel::position_nudge_repel
#' @export
gggda::minpp
#' @export
gggda::maxpp
#' @export
gggda::minabspp

#' @rdname biplot-geoms
#' @export
geom_rows_point <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomPoint, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_point <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomPoint, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_path <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomPath, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(lineend = lineend, 
            linejoin = linejoin, linemitre = linemitre, 
            arrow = arrow, na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_path <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomPath, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(lineend = lineend, 
            linejoin = linejoin, linemitre = linemitre, 
            arrow = arrow, na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_polygon <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  rule = "evenodd",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomPolygon, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(na.rm = na.rm, 
            rule = rule, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_polygon <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  rule = "evenodd",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomPolygon, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(na.rm = na.rm, 
            rule = rule, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_contour <- function(
  mapping = NULL,
  data = NULL,
  stat = "contour",
  position = "identity",
  ...,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomContour, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(bins = bins, 
            binwidth = binwidth, breaks = breaks, lineend = lineend, 
            linejoin = linejoin, linemitre = linemitre, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_contour <- function(
  mapping = NULL,
  data = NULL,
  stat = "contour",
  position = "identity",
  ...,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomContour, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(bins = bins, 
            binwidth = binwidth, breaks = breaks, lineend = lineend, 
            linejoin = linejoin, linemitre = linemitre, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_density_2d <- function(
  mapping = NULL,
  data = NULL,
  stat = "density_2d",
  position = "identity",
  ...,
  contour_var = "density",
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomDensity2d, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(lineend = lineend, 
            linejoin = linejoin, linemitre = linemitre, 
            contour = TRUE, contour_var = contour_var, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_density_2d <- function(
  mapping = NULL,
  data = NULL,
  stat = "density_2d",
  position = "identity",
  ...,
  contour_var = "density",
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomDensity2d, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(lineend = lineend, 
            linejoin = linejoin, linemitre = linemitre, 
            contour = TRUE, contour_var = contour_var, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_density_2d_filled <- function(
  mapping = NULL,
  data = NULL,
  stat = "density_2d_filled",
  position = "identity",
  ...,
  contour_var = "density",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomDensity2dFilled, position = position, 
        show.legend = show.legend, inherit.aes = inherit.aes, 
        params = list2(na.rm = na.rm, contour = TRUE, contour_var = contour_var, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_density_2d_filled <- function(
  mapping = NULL,
  data = NULL,
  stat = "density_2d_filled",
  position = "identity",
  ...,
  contour_var = "density",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomDensity2dFilled, position = position, 
        show.legend = show.legend, inherit.aes = inherit.aes, 
        params = list2(na.rm = na.rm, contour = TRUE, contour_var = contour_var, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_text <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  check_overlap = FALSE,
  size.unit = "mm",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    if (!missing(nudge_x) || !missing(nudge_y)) {
        if (!missing(position)) {
            cli::cli_abort(c("Both {.arg position} and {.arg nudge_x}/{.arg nudge_y} are supplied.", 
                i = "Only use one approach to alter the position."))
        }
        position <- position_nudge(nudge_x, nudge_y)
    }
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomText, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(parse = parse, 
            check_overlap = check_overlap, size.unit = size.unit, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_text <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  check_overlap = FALSE,
  size.unit = "mm",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    if (!missing(nudge_x) || !missing(nudge_y)) {
        if (!missing(position)) {
            cli::cli_abort(c("Both {.arg position} and {.arg nudge_x}/{.arg nudge_y} are supplied.", 
                i = "Only use one approach to alter the position."))
        }
        position <- position_nudge(nudge_x, nudge_y)
    }
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomText, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(parse = parse, 
            check_overlap = check_overlap, size.unit = size.unit, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_label <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0.25,
  size.unit = "mm",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    if (!missing(nudge_x) || !missing(nudge_y)) {
        if (!missing(position)) {
            cli::cli_abort(c("Both {.arg position} and {.arg nudge_x}/{.arg nudge_y} are supplied.", 
                i = "Choose one approach to alter the position."))
        }
        position <- position_nudge(nudge_x, nudge_y)
    }
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomLabel, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(parse = parse, 
            label.padding = label.padding, label.r = label.r, 
            label.size = label.size, size.unit = size.unit, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_label <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0.25,
  size.unit = "mm",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    if (!missing(nudge_x) || !missing(nudge_y)) {
        if (!missing(position)) {
            cli::cli_abort(c("Both {.arg position} and {.arg nudge_x}/{.arg nudge_y} are supplied.", 
                i = "Choose one approach to alter the position."))
        }
        position <- position_nudge(nudge_x, nudge_y)
    }
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomLabel, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list2(parse = parse, 
            label.padding = label.padding, label.r = label.r, 
            label.size = label.size, size.unit = size.unit, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_text_repel <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  parse = FALSE,
  ...,
  box.padding = 0.25,
  point.padding = 1e-06,
  min.segment.length = 0.5,
  arrow = NULL,
  force = 1,
  force_pull = 1,
  max.time = 0.5,
  max.iter = 10000,
  max.overlaps = getOption("ggrepel.max.overlaps", default = 10),
  nudge_x = 0,
  nudge_y = 0,
  xlim = c(NA, NA),
  ylim = c(NA, NA),
  na.rm = FALSE,
  show.legend = NA,
  direction = c("both", "y", "x"),
  seed = NA,
  verbose = FALSE,
  inherit.aes = TRUE
) {
    if (!missing(nudge_x) || !missing(nudge_y)) {
        if (!missing(position)) {
            stop("Specify either `position` or `nudge_x`/`nudge_y`", 
                call. = FALSE)
        }
        position <- position_nudge_repel(nudge_x, nudge_y)
    }
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomTextRepel, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(parse = parse, 
            na.rm = na.rm, box.padding = to_unit(box.padding), 
            point.padding = to_unit(point.padding), min.segment.length = to_unit(min.segment.length), 
            arrow = arrow, force = force, force_pull = force_pull, 
            max.time = max.time, max.iter = max.iter, max.overlaps = max.overlaps, 
            nudge_x = nudge_x, nudge_y = nudge_y, xlim = xlim, 
            ylim = ylim, direction = match.arg(direction), 
            seed = seed, verbose = verbose, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_text_repel <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  parse = FALSE,
  ...,
  box.padding = 0.25,
  point.padding = 1e-06,
  min.segment.length = 0.5,
  arrow = NULL,
  force = 1,
  force_pull = 1,
  max.time = 0.5,
  max.iter = 10000,
  max.overlaps = getOption("ggrepel.max.overlaps", default = 10),
  nudge_x = 0,
  nudge_y = 0,
  xlim = c(NA, NA),
  ylim = c(NA, NA),
  na.rm = FALSE,
  show.legend = NA,
  direction = c("both", "y", "x"),
  seed = NA,
  verbose = FALSE,
  inherit.aes = TRUE
) {
    if (!missing(nudge_x) || !missing(nudge_y)) {
        if (!missing(position)) {
            stop("Specify either `position` or `nudge_x`/`nudge_y`", 
                call. = FALSE)
        }
        position <- position_nudge_repel(nudge_x, nudge_y)
    }
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomTextRepel, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(parse = parse, 
            na.rm = na.rm, box.padding = to_unit(box.padding), 
            point.padding = to_unit(point.padding), min.segment.length = to_unit(min.segment.length), 
            arrow = arrow, force = force, force_pull = force_pull, 
            max.time = max.time, max.iter = max.iter, max.overlaps = max.overlaps, 
            nudge_x = nudge_x, nudge_y = nudge_y, xlim = xlim, 
            ylim = ylim, direction = match.arg(direction), 
            seed = seed, verbose = verbose, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_label_repel <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  parse = FALSE,
  ...,
  box.padding = 0.25,
  label.padding = 0.25,
  point.padding = 1e-06,
  label.r = 0.15,
  label.size = 0.25,
  min.segment.length = 0.5,
  arrow = NULL,
  force = 1,
  force_pull = 1,
  max.time = 0.5,
  max.iter = 10000,
  max.overlaps = getOption("ggrepel.max.overlaps", default = 10),
  nudge_x = 0,
  nudge_y = 0,
  xlim = c(NA, NA),
  ylim = c(NA, NA),
  na.rm = FALSE,
  show.legend = NA,
  direction = c("both", "y", "x"),
  seed = NA,
  verbose = FALSE,
  inherit.aes = TRUE
) {
    if (!missing(nudge_x) || !missing(nudge_y)) {
        if (!missing(position)) {
            stop("Specify either `position` or `nudge_x`/`nudge_y`", 
                call. = FALSE)
        }
        position <- position_nudge_repel(nudge_x, nudge_y)
    }
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomLabelRepel, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(parse = parse, 
            box.padding = to_unit(box.padding), label.padding = to_unit(label.padding), 
            point.padding = to_unit(point.padding), label.r = to_unit(label.r), 
            label.size = label.size, min.segment.length = to_unit(min.segment.length), 
            arrow = arrow, na.rm = na.rm, force = force, 
            force_pull = force_pull, max.time = max.time, 
            max.iter = max.iter, max.overlaps = max.overlaps, 
            nudge_x = nudge_x, nudge_y = nudge_y, xlim = xlim, 
            ylim = ylim, direction = match.arg(direction), 
            seed = seed, verbose = verbose, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_label_repel <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  parse = FALSE,
  ...,
  box.padding = 0.25,
  label.padding = 0.25,
  point.padding = 1e-06,
  label.r = 0.15,
  label.size = 0.25,
  min.segment.length = 0.5,
  arrow = NULL,
  force = 1,
  force_pull = 1,
  max.time = 0.5,
  max.iter = 10000,
  max.overlaps = getOption("ggrepel.max.overlaps", default = 10),
  nudge_x = 0,
  nudge_y = 0,
  xlim = c(NA, NA),
  ylim = c(NA, NA),
  na.rm = FALSE,
  show.legend = NA,
  direction = c("both", "y", "x"),
  seed = NA,
  verbose = FALSE,
  inherit.aes = TRUE
) {
    if (!missing(nudge_x) || !missing(nudge_y)) {
        if (!missing(position)) {
            stop("Specify either `position` or `nudge_x`/`nudge_y`", 
                call. = FALSE)
        }
        position <- position_nudge_repel(nudge_x, nudge_y)
    }
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomLabelRepel, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(parse = parse, 
            box.padding = to_unit(box.padding), label.padding = to_unit(label.padding), 
            point.padding = to_unit(point.padding), label.r = to_unit(label.r), 
            label.size = label.size, min.segment.length = to_unit(min.segment.length), 
            arrow = arrow, na.rm = na.rm, force = force, 
            force_pull = force_pull, max.time = max.time, 
            max.iter = max.iter, max.overlaps = max.overlaps, 
            nudge_x = nudge_x, nudge_y = nudge_y, xlim = xlim, 
            ylim = ylim, direction = match.arg(direction), 
            seed = seed, verbose = verbose, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_axis <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  axis_labels = TRUE,
  axis_ticks = TRUE,
  axis_text = TRUE,
  by = NULL,
  num = NULL,
  tick_length = 0.025,
  text_dodge = 0.03,
  label_dodge = 0.03,
  ...,
  axis.colour = NULL,
  axis.color = NULL,
  axis.alpha = NULL,
  label.angle = 0,
  label.colour = NULL,
  label.color = NULL,
  label.alpha = NULL,
  tick.linewidth = 0.25,
  tick.colour = NULL,
  tick.color = NULL,
  tick.alpha = NULL,
  text.size = 2.6,
  text.angle = 0,
  text.hjust = 0.5,
  text.vjust = 0.5,
  text.family = NULL,
  text.fontface = NULL,
  text.colour = NULL,
  text.color = NULL,
  text.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomAxis, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(axis_labels = axis_labels, 
            axis_ticks = axis_ticks, axis_text = axis_text, 
            by = by, num = num, tick_length = tick_length, 
            text_dodge = text_dodge, label_dodge = label_dodge, 
            axis.colour = axis.color %||% axis.colour, 
            axis.alpha = axis.alpha, label.angle = label.angle, 
            label.colour = label.color %||% label.colour, 
            label.alpha = label.alpha, tick.linewidth = tick.linewidth, 
            tick.colour = tick.color %||% tick.colour, 
            tick.alpha = tick.alpha, text.size = text.size, 
            text.angle = text.angle, text.hjust = text.hjust, 
            text.vjust = text.vjust, text.family = text.family, 
            text.fontface = text.fontface, text.colour = text.color %||% 
                text.colour, text.alpha = text.alpha, parse = parse, 
            check_overlap = check_overlap, na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_axis <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  axis_labels = TRUE,
  axis_ticks = TRUE,
  axis_text = TRUE,
  by = NULL,
  num = NULL,
  tick_length = 0.025,
  text_dodge = 0.03,
  label_dodge = 0.03,
  ...,
  axis.colour = NULL,
  axis.color = NULL,
  axis.alpha = NULL,
  label.angle = 0,
  label.colour = NULL,
  label.color = NULL,
  label.alpha = NULL,
  tick.linewidth = 0.25,
  tick.colour = NULL,
  tick.color = NULL,
  tick.alpha = NULL,
  text.size = 2.6,
  text.angle = 0,
  text.hjust = 0.5,
  text.vjust = 0.5,
  text.family = NULL,
  text.fontface = NULL,
  text.colour = NULL,
  text.color = NULL,
  text.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomAxis, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(axis_labels = axis_labels, 
            axis_ticks = axis_ticks, axis_text = axis_text, 
            by = by, num = num, tick_length = tick_length, 
            text_dodge = text_dodge, label_dodge = label_dodge, 
            axis.colour = axis.color %||% axis.colour, 
            axis.alpha = axis.alpha, label.angle = label.angle, 
            label.colour = label.color %||% label.colour, 
            label.alpha = label.alpha, tick.linewidth = tick.linewidth, 
            tick.colour = tick.color %||% tick.colour, 
            tick.alpha = tick.alpha, text.size = text.size, 
            text.angle = text.angle, text.hjust = text.hjust, 
            text.vjust = text.vjust, text.family = text.family, 
            text.fontface = text.fontface, text.colour = text.color %||% 
                text.colour, text.alpha = text.alpha, parse = parse, 
            check_overlap = check_overlap, na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_pointranges <- function(
  mapping = NULL,
  data = NULL,
  stat = "center",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomPointranges, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_pointranges <- function(
  mapping = NULL,
  data = NULL,
  stat = "center",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomPointranges, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_lineranges <- function(
  mapping = NULL,
  data = NULL,
  stat = "center",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomLineranges, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_lineranges <- function(
  mapping = NULL,
  data = NULL,
  stat = "center",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomLineranges, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_isoline <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  isoline_text = TRUE,
  by = NULL,
  num = NULL,
  text_dodge = 0.03,
  ...,
  text.size = 3,
  text.angle = 0,
  text.colour = NULL,
  text.color = NULL,
  text.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomIsoline, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(isoline_text = isoline_text, 
            by = by, num = num, text_dodge = text_dodge, 
            text.size = text.size, text.angle = text.angle, 
            text.colour = text.color %||% text.colour, 
            text.alpha = text.alpha, parse = parse, check_overlap = check_overlap, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_isoline <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  isoline_text = TRUE,
  by = NULL,
  num = NULL,
  text_dodge = 0.03,
  ...,
  text.size = 3,
  text.angle = 0,
  text.colour = NULL,
  text.color = NULL,
  text.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomIsoline, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(isoline_text = isoline_text, 
            by = by, num = num, text_dodge = text_dodge, 
            text.size = text.size, text.angle = text.angle, 
            text.colour = text.color %||% text.colour, 
            text.alpha = text.alpha, parse = parse, check_overlap = check_overlap, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_text_radiate <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomTextRadiate, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(parse = parse, 
            check_overlap = check_overlap, na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_text_radiate <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomTextRadiate, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(parse = parse, 
            check_overlap = check_overlap, na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_vector <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  arrow = default_arrow,
  lineend = "round",
  linejoin = "mitre",
  vector_labels = TRUE,
  ...,
  label.colour = NULL,
  label.color = NULL,
  label.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomVector, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(arrow = arrow, 
            lineend = lineend, linejoin = linejoin, vector_labels = vector_labels, 
            label.colour = label.color %||% label.colour, 
            label.alpha = label.alpha, parse = parse, check_overlap = check_overlap, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_vector <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  arrow = default_arrow,
  lineend = "round",
  linejoin = "mitre",
  vector_labels = TRUE,
  ...,
  label.colour = NULL,
  label.color = NULL,
  label.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomVector, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(arrow = arrow, 
            lineend = lineend, linejoin = linejoin, vector_labels = vector_labels, 
            label.colour = label.color %||% label.colour, 
            label.alpha = label.alpha, parse = parse, check_overlap = check_overlap, 
            na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_bagplot <- function(
  mapping = NULL,
  data = NULL,
  stat = "bagplot",
  position = "identity",
  ...,
  bag.linewidth = sync(),
  bag.linetype = sync(),
  bag.colour = "black",
  bag.color = NULL,
  bag.fill = sync(),
  bag.alpha = NA,
  median.shape = 21L,
  median.stroke = sync(),
  median.size = 5,
  median.colour = sync(),
  median.color = NULL,
  median.fill = "white",
  median.alpha = NA,
  fence.linewidth = 0.25,
  fence.linetype = 0L,
  fence.colour = sync(),
  fence.color = NULL,
  fence.fill = sync(),
  fence.alpha = 0.25,
  outlier.shape = sync(),
  outlier.stroke = sync(),
  outlier.size = sync(),
  outlier.colour = sync(),
  outlier.color = NULL,
  outlier.fill = NA,
  outlier.alpha = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    bag_gp <- list(linewidth = bag.linewidth, linetype = bag.linetype, 
        colour = bag.color %||% bag.colour, fill = bag.fill, 
        alpha = bag.alpha)
    median_gp <- list(shape = median.shape, stroke = median.stroke, 
        size = median.size, colour = median.color %||% 
            median.colour, fill = median.fill, alpha = median.alpha)
    fence_gp <- list(linewidth = fence.linewidth, linetype = fence.linetype, 
        colour = fence.color %||% fence.colour, fill = fence.fill, 
        alpha = fence.alpha)
    outlier_gp <- list(shape = outlier.shape, stroke = outlier.stroke, 
        size = outlier.size, colour = outlier.color %||% 
            outlier.colour, fill = outlier.fill, alpha = outlier.alpha)
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomBagplot, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(bag_gp = bag_gp, 
            median_gp = median_gp, fence_gp = fence_gp, 
            outlier_gp = outlier_gp, na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_bagplot <- function(
  mapping = NULL,
  data = NULL,
  stat = "bagplot",
  position = "identity",
  ...,
  bag.linewidth = sync(),
  bag.linetype = sync(),
  bag.colour = "black",
  bag.color = NULL,
  bag.fill = sync(),
  bag.alpha = NA,
  median.shape = 21L,
  median.stroke = sync(),
  median.size = 5,
  median.colour = sync(),
  median.color = NULL,
  median.fill = "white",
  median.alpha = NA,
  fence.linewidth = 0.25,
  fence.linetype = 0L,
  fence.colour = sync(),
  fence.color = NULL,
  fence.fill = sync(),
  fence.alpha = 0.25,
  outlier.shape = sync(),
  outlier.stroke = sync(),
  outlier.size = sync(),
  outlier.colour = sync(),
  outlier.color = NULL,
  outlier.fill = NA,
  outlier.alpha = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    bag_gp <- list(linewidth = bag.linewidth, linetype = bag.linetype, 
        colour = bag.color %||% bag.colour, fill = bag.fill, 
        alpha = bag.alpha)
    median_gp <- list(shape = median.shape, stroke = median.stroke, 
        size = median.size, colour = median.color %||% 
            median.colour, fill = median.fill, alpha = median.alpha)
    fence_gp <- list(linewidth = fence.linewidth, linetype = fence.linetype, 
        colour = fence.color %||% fence.colour, fill = fence.fill, 
        alpha = fence.alpha)
    outlier_gp <- list(shape = outlier.shape, stroke = outlier.stroke, 
        size = outlier.size, colour = outlier.color %||% 
            outlier.colour, fill = outlier.fill, alpha = outlier.alpha)
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomBagplot, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(bag_gp = bag_gp, 
            median_gp = median_gp, fence_gp = fence_gp, 
            outlier_gp = outlier_gp, na.rm = na.rm, ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_rule <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  axis_labels = TRUE,
  axis_ticks = TRUE,
  axis_text = TRUE,
  by = NULL,
  num = NULL,
  snap_rule = TRUE,
  tick_length = 0.025,
  text_dodge = 0.03,
  label_dodge = 0.03,
  ...,
  axis.colour = NULL,
  axis.color = NULL,
  axis.alpha = NULL,
  label.angle = 0,
  label.colour = NULL,
  label.color = NULL,
  label.alpha = NULL,
  tick.linewidth = 0.25,
  tick.colour = NULL,
  tick.color = NULL,
  tick.alpha = NULL,
  text.size = 2.6,
  text.angle = 0,
  text.hjust = 0.5,
  text.vjust = 0.5,
  text.family = NULL,
  text.fontface = NULL,
  text.colour = NULL,
  text.color = NULL,
  text.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomRule, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(axis_labels = axis_labels, 
            axis_ticks = axis_ticks, axis_text = axis_text, 
            by = by, num = num, snap_rule = snap_rule, 
            tick_length = tick_length, text_dodge = text_dodge, 
            label_dodge = label_dodge, axis.colour = axis.color %||% 
                axis.colour, axis.alpha = axis.alpha, label.angle = label.angle, 
            label.colour = label.color %||% label.colour, 
            label.alpha = label.alpha, tick.linewidth = tick.linewidth, 
            tick.colour = tick.color %||% tick.colour, 
            tick.alpha = tick.alpha, text.size = text.size, 
            text.angle = text.angle, text.hjust = text.hjust, 
            text.vjust = text.vjust, text.family = text.family, 
            text.fontface = text.fontface, text.colour = text.color %||% 
                text.colour, text.alpha = text.alpha, parse = parse, 
            check_overlap = check_overlap, na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_rule <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  axis_labels = TRUE,
  axis_ticks = TRUE,
  axis_text = TRUE,
  by = NULL,
  num = NULL,
  snap_rule = TRUE,
  tick_length = 0.025,
  text_dodge = 0.03,
  label_dodge = 0.03,
  ...,
  axis.colour = NULL,
  axis.color = NULL,
  axis.alpha = NULL,
  label.angle = 0,
  label.colour = NULL,
  label.color = NULL,
  label.alpha = NULL,
  tick.linewidth = 0.25,
  tick.colour = NULL,
  tick.color = NULL,
  tick.alpha = NULL,
  text.size = 2.6,
  text.angle = 0,
  text.hjust = 0.5,
  text.vjust = 0.5,
  text.family = NULL,
  text.fontface = NULL,
  text.colour = NULL,
  text.color = NULL,
  text.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomRule, position = position, show.legend = show.legend, 
        inherit.aes = inherit.aes, params = list(axis_labels = axis_labels, 
            axis_ticks = axis_ticks, axis_text = axis_text, 
            by = by, num = num, snap_rule = snap_rule, 
            tick_length = tick_length, text_dodge = text_dodge, 
            label_dodge = label_dodge, axis.colour = axis.color %||% 
                axis.colour, axis.alpha = axis.alpha, label.angle = label.angle, 
            label.colour = label.color %||% label.colour, 
            label.alpha = label.alpha, tick.linewidth = tick.linewidth, 
            tick.colour = tick.color %||% tick.colour, 
            tick.alpha = tick.alpha, text.size = text.size, 
            text.angle = text.angle, text.hjust = text.hjust, 
            text.vjust = text.vjust, text.family = text.family, 
            text.fontface = text.fontface, text.colour = text.color %||% 
                text.colour, text.alpha = text.alpha, parse = parse, 
            check_overlap = check_overlap, na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_rows_interpolation <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  new_data = NULL,
  type = c("centroid", "sequence"),
  arrow = default_arrow,
  ...,
  point.fill = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = rows_stat(stat), 
        geom = GeomInterpolation, position = position, 
        show.legend = show.legend, inherit.aes = inherit.aes, 
        params = list(new_data = new_data, type = type, 
            point.fill = point.fill, arrow = arrow, na.rm = na.rm, 
            ...))    
    
}

#' @rdname biplot-geoms
#' @export
geom_cols_interpolation <- function(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  new_data = NULL,
  type = c("centroid", "sequence"),
  arrow = default_arrow,
  ...,
  point.fill = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
    layer(data = data, mapping = mapping, stat = cols_stat(stat), 
        geom = GeomInterpolation, position = position, 
        show.legend = show.legend, inherit.aes = inherit.aes, 
        params = list(new_data = new_data, type = type, 
            point.fill = point.fill, arrow = arrow, na.rm = na.rm, 
            ...))    
    
}
