# Documentation for data sets.

#' Degree of disease measured at two points in time for mine workers.
#'
#' Based on radiological measurements, the matrix contains the degree of pneumoconiosis
#' in coal workers.  1 = least severe disease and 4 = most severe.
#'
#' @format ## `coal_g`
#' A matrix with 4 rows and 4 columns.
#'
#' @source McCullagh, P. (1977).  A logistic model for paired comparisons with ordered
#' categorical data. Biometrika, 64(3), 449-453.
"coal_g"


#' Participation in household budgeting by psychiatric patients.
#' Rows are ratings by patient, columns are ratings by relative.
#' 1 - not at all
#' 2 - doing some
#' 3 - doing regularly
#'
#' @format ##  `budget_actual`
#' A matrix with 3 rows and 3 columns
#'
#' @source Schuster, C, (2001). Kappa as a parameter of a symmetry model for
#' rater agreement. Journal of Educational and Behavioral Statistics,
#' 26(3), 331-342.
"budget_actual"


#' Ratings of expected participation in household budgeting by
#' psychiatric patients.
#' Rows are ratings by patient, columns are ratings by relative.
#' 1 - not at all
#' 2 - doing some
#' 3 - doing regularly
#' @format  ## `budget_expected`
#' a matrix with 3 rows and 3 columns.
#'
#' @source Schuster, C, (2001). Kappa as a parameter of a symmetry model for
#' rater agreement. Journal of Educational and Behavioral Statistics,
#' 26(3), 331-342.
"budget_expected"


#' Ratings of severity of patient's depression by two therapists.
#'
#' 1 = slight
#' 2 = moderate
#' 3 = severe
#'
#' @format ## `depression`
#' A matrix with 3 rows and 3 columns.
#'
#' @source von Eye, A. & Mun, E. Y. (2005, p.41). Analyzing rater agreement: Manifest variable
#' methods.  Mahwah, NJ: Lawrence Erlbaum.
"depression"


#' Dehydration in dogs data set.
#'
#' An interrater agreement data set from Shourki, M. M. (2005, p.80).
#' It is agreement study of two clinicians evaluating whether dogs were dehydrated.
#' The lowest score indicates normal, and the highest score indicates dehydrated (above 10%).
#' The "g" in the name indicates that this is taken from mine "G" in the original study.
#'
#' @format ## `dogs`
#' A matrix with 4 rows and 4 columns.
#'
#' @source Shoukri, M. M. (2005). The measurement of interobserver agreement. New York: Chapman & Hall.
"dogs"


#' Occurrence of side effects after gastro-intestinal surgery.
#'
#' Columns
#' 1 = None
#' 2 = Slight
#' 3 = Moderate
#'
#' Rows
#' Hospital A
#' Hospital B
#' Hospital C
#' Hospital D
#'
#' @format ## `dumping`
#' A matrix with 4 rows and 3 columns
#'
#' @source Agresti, A. (1984, p. 63). Analysis of ordinal categorical data.  Naew York: Wiley.
"dumping"


#' Severity of disturbing dreams in adolescent boys, measured at two ages..
#'
#' @format ## `dreams`
#' A matrix with 4 rows and 4 columns.
#'
#' @source McCullagh, P. (1980, p.117). Regression models for ordinal data.  Journal of
#' the Royal Statistical Society, Series B, 42(2), 109-142.
"dreams"

#' Ratings of number of hot drinks consumed by cases with cancer of the esophagus,
#' compared with control subjects.
#'
#' @format ## `esophageal_cancer`
#' A matrix with 4 rows and 4 columns.
#'
#' @source
#' Agresti, A. (1984, p. 217). Analysis of ordinal categorical data. New York, Wiley.
"esophageal_cancer"


#' Family income for two years from US census.
#'
#' @format ## `family_income`
#' A matrix with 2 rows and 7 columns. Rows are years 1960 and 1970.
#' Columns are income range.
#'
#' @source McCullagh, P. (1980, p.114). Regression models for ordinal data.  Journal of
#' the Royal Statistical Society, Series B, 42(2), 109-142.
"family_income"


#' Ratings of visual acuity for men and women employed at the Royal Ordinance factories,
#' 1943-1946.
#'
#' 1 = best visual acuity
#' 4 = worst visual acuity
#' @format ## `gender_vision`
#' A matrix with 2 rows for the genders and 4 columns for visual acuity.
#'
#' @source McCullagh, P. (1980, p. 119). Regression models for ordinal data. Journal of
#' the Royal Statistical Society, Series B, 42(2), 109-142.
"gender_vision"


#' Data about charges of homicide in the state of Florida.
#'
#' Counts of cases charged with homicide. The rows and columns indicate whether there
#' was an additional charge of a felony occurring in addition to the homicide.
#' The data is actually 3-dimensional.  It is stored as 4 related matrices, each
#' with the leading word "homicide_" The rest of the name gives the race of the defendant
#' and the race of the victim, separated by an underscore
#'
#' @format ## `homicide_black_black`
#' Each is a matrix with 3 rows and 3 columns.  Rows are classification by police
#' and columns are classification by the court/prosecutor.
#' 1 = No felony
#' 2 = Possible felony
#' 2 = Felony
#'
#' @source Agresti, A. (1984, p. 211). Analysis of ordinal categorical data. New York: Wiley.
"homicide_black_black"


#' Data about charges of homicide in the state of Florida.
#'
#' Counts of cases charged with homicide. The rows and columns indicate whether there
#' was an additional charge of a felony occurring in addition to the homicide.
#' The data is actually 3-dimensional.  It is stored as 4 related matrices, each
#' with the leading word "homicide_" The rest of the name gives the race of the defendant
#' and the race of the victim, separated by an underscore.
#'
#' @format ## `homicide_black_white`
#' Each is a matrix with 3 rows and 3 columns.  Rows are classification by police
#' and columns are classification by the court/prosecutor.
#' 1 = No felony
#' 2 = Possible felony
#' 2 = Felony
#'
#' @source Agresti, A. (1984, p. 211). Analysis of ordinal categorical data. New York: Wiley.
"homicide_black_white"


#' Data about charges of homicide in the state of Florida.
#'
#' Counts of cases charged with homicide. The rows and columns indicate whether there
#' was an additional charge of a felony occurring in addition to the homicide.
#' The data is actually 3-dimensional.  It is stored as 4 related matrices, each
#' with the leading word "homicide_" The rest of the name gives the race of the defendant
#' and the race of the victim, separated by an underscore
#'
#' @format ## `homicide_white_black`
#' Each is a matrix with 3 rows and 3 columns.  Rows are classification by police
#' and columns are classification by the court/prosecutor.
#' 1 = No felony
#' 2 = Possible felony
#' 2 = Felony
#'
#' @source Agresti, A. (1984, p. 211). Analysis of ordinal categorical data. New York: Wiley.
"homicide_white_black"


#' Data about charges of homicide in the state of Florida.
#'
#' Counts of cases charged with homicide. The rows and columns indicate whether there
#' was an additional charge of a felony occurring in addition to the homicide.
#' The data is actually 3-dimensional.  It is stored as 4 related matrices, each
#' with the leading word "homicide_" The rest of the name gives the race of the defendant
#' and the race of the victim, separated by an underscore
#'
#' @format ## `homicide_white_white`
#' Each is a matrix with 3 rows and 3 columns.  Rows are classification by police
#' and columns are classification by the court/prosecutor.
#' 1 = No felony
#' 2 = Possible felony
#' 2 = Felony
#'
#' @source Agresti, A. (1984, p. 211). Analysis of ordinal categorical data. New York: Wiley.
"homicide_white_white"


#' Measures of men's hypothalamus taken from cadavers.  First data set.
#'
#' @format # `hypothalamus_1`
#' Each set is a dominance matrix (see e.g., Cliff 1996).
#'
#' @source Cliff, N. (1996), Ordinal methods for behavioral data analysis. Mahwah NJ:
#' Lawrence Erlbaum.
"hypothalamus_1"


#'Measures of men's hypothalamus taken from cadavers. Second data set.
#'
#' @format # `hypothalamus_2`
#' Each set is a dominance matrix (see e.g., Cliff 1996).
#'
#' @source Cliff, N. (1996), Ordinal methods for behavioral data analysis. Mahwah NJ:
#' Lawrence Erlbaum.
"hypothalamus_2"


#' Measures of interference in memory recall study.
#'
#' Measures are within subjects, comparing a control condition to two conditions
#' with interference.  Control v. interference condition 1
#'
#' @format ## `interference_control_1`, `interference_control_2`, `interference_12`
#' Within-persons dominance matrices.
#'
#' @source Cliff, N. (1996). Ordinal methods for behavioral data analysis. Mahwah NJ:
#' Lawrence Erlbaum.
"interference_control_1"


#' Measures of interference in memory recall study.
#'
#' Measures are within subjects, comparing a control condition to two conditions
#' with interference.  Control v. interference condition 2
#'
#' @format ## `interference_control_1`, `interference_control_2`, `interference_12`
#' Within-persons dominance matrices.
#'
#' @source Cliff, N. (1996). Ordinal methods for behavioral data analysis. Mahwah NJ:
#' Lawrence Erlba
"interference_control_2"


#' Measures of interference in memory recall study.
#'
#' Measures are within subjects, comparing a control condition to two conditions
#' with interference. Interference condition 1 v. interference condition 2
#'
#' @format ## `interference_control_1`, `interference_control_2`, `interference_12`
#' Within-persons dominance matrices.
#'
#' @source Cliff, N. (1996). Ordinal methods for behavioral data analysis. Mahwah NJ:
#' Lawrence Erlba
"interference_12"


#' Relationship between child's mental health and parents' socioeconomic status.
#'
#' Rows are child's mental health (ranging from 1 = well to 4 = impaired),
#' and columns are parents' socioeconomic status, A - F.
#'
#' @format ## `mental_health`
#' A matrix with 4 rows and 6 columns
#'
#' @source Goodman, L. A. (1979). Simple models for the analysis of association
#' in cross-classifications having ordered categories.
"mental_health"


#' Movie ratings by two film critics, Siskel and Ebert.
#'
#' @format ## `movies`
#' A matrix with 3 rows and 3 columns
#' 1 is con
#' 2 is mixed
#' 3 is pro
#'
#' @source
#' https://online.stat.psu.edu/stat504/lesson/11/11.3
"movies"


#' Agreement between two clinicians on presence of multiple sclerosis
#' based on file.
#'
#' See companion winnipeg_data.
#'
#' @format ## `new_orleans_data`
#' A matrix with 4 rows and 4 columns
#' Ratings range from definite presence of disease to definite absence.
#' @source
#' ???
"new_orleans_data"


#' Cross tabulation of father's employment status with son's employment status.
#'
#' Higher numbers correspond to higher status occupation
#'
#' @format ## `occupational_status`
#' A matrix with 6 rows and 6 columns
#'
#' @source
#' ???
"occupational_status"


#' Interrater agreement of two psychologists' ratings of paranoia.
#'
#' Severity corresponds to level
#' 1 low
#' 3 high
#'
#' @format ## `paranoia`
#' A matrix with 3 rows and 3 columns.
#'
#' @source von Eye, A. & Mun, E. Y. (2005, p. 70).  Analyzing rater agreement: Manifest variable
#' methods.  Mahwah, NJ: Lawrence Erlbaum.
"paranoia"


#' Interrater agreement of two radiologists diagnosis of severity of carcinoma.
#'
#' The data contains a comparison vector of (simulated) covariate data.
#' @format ## `radiology` `covariate`
#' A matrix with 4 rows and 4 columns, and a vector of 16 elements.
#'
#' @source von Eye, A. & Mun, E. Y. (2005, p. 60).  Analyzing rater agreement: Manifest variable
#' methods.  Mahwah, NJ: Lawrence Erlbaum.
"radiology"
"covariate"


#' Social mobility data with father's occupational social status and
#' son's occupational social status.
#'
#' @format ## `social_status`
#' A matrix with 7 rows and 7 columns
#'
#' @source Goodman, L. A. (1979). Simple models for the analysis of association
#' in cross-classifications having ordered categories.  Journal of the American Statistical
#' Association, 74(367), 537-552.
"social_status"


#' Social mobility data with father's occupational social status and
#' son's occupational social status. * categories instead of 7 in social status..
#'
#' @format ## `social_status2`
#' A matrix with 8 rows and 8 columns
#'
#' @source Goodman, L. A. (1979). Simple models for the analysis of association
#' in cross-classifications having ordered categories.  Journal of the American Statistical
#' Association, 74(367), 537-552.
"social_status2"


#' Taste ratings
#'
#' @format ## `taste`
#' A matrix with 5 rows and 5 columns.
#'
#' @source McCullagh, P. (1980, p. 119). Regression models for ordinal data. Journal of
#' the Royal Statistical Society, Series B, 42(2), 109-142.
"taste"


#' Teachers ratings of their students intelligence.
#'
#' Interrater agreement data for two teachers asked to rate the intelligence
#' of their students.
#'
#' @format ## `teachers`
#' A matrix with 4 rows and 4 columns.  Higher scores correspond to higher
#' estimated intelligence.
#'
#' @source von Eye, A. & Mun, E. Y. (2005, p. 36).  Analyzing rater agreement: Manifest variable
#' methods.  Mahwah, NJ: Lawrence Erlbaum.
"teachers"


#' Style of teachers rated by supervisors
#'
#' Ratings of style of teaching by supervisors.
#'  1 indicates Authoritarian,
#'  2 indicates Democratic,
#'  3 indicates Permissive.
#'
#'  @format ## `teaching_style`
#'  A matrix with 3 rows and 3 columns.
#'
#'  @source Agresti, A. (1989). An agreement model with kappa as parameter. Statistics &
#'  Probability Letters, 7, 271-273.
"teaching_style"


#' Relationship between size of child's tonsils and their status as a carrier of a disease.
#'
#' @format ## `tonsils`
#' A matrix with 2 rows and 3 columns.  Rows are disease status and columns are ratings of
#' tonsil size.
#'
#' @source McCullagh, P. (1980). Regression models for ordinal data. Journal of
#' the Royal Statistical Society, Series B, 42(2), 109-142.
"tonsils"


#' Interrater agreement of two journalists' evaluation of proposed TV programs.
#'
#' Ratings go from low to high probability of the show's success.
#'
#' @format ## `tv`
#' A matrix of 6 rows and 6 columns.
#'
#' @source von Eye, A. & Mun, E. Y. (2005, p. 56).  Analyzing rater agreement: Manifest variable
#' methods.  Mahwah, NJ: Lawrence Erlbaum.
"tv"


#' Visual acuity of women factory workers.
#'
#' Measurements of unaided visual acuity for women working at the Royal Ordinance
#' factories 1943-1946. Rows are right eye, columns are left eye. 1 indicates best vision,
#' 4 is poorest.
#'
#' @format ## `visual_data`
#' A matrix with 4 rows and 4 columns.
#'
#' @source Stuart, A. (1953). The estimation and comparison of strengths of association
#' in contingency tables.  Biometrika, 40(1/2), 105-110.
"vision_data"


#' Visual acuity of men factory workers.
#'
#' Measurements of unaided visual acuity for men working at the Royal Ordinance
#' factories 1943-1946. Rows are right eye, columns are left eye. 1 indicates best vision,
#' 4 is poorest.
#'
#' @format ## `visual_data_men`
#' A matrix with 4 rows and 4 columns.
#'
#' @source Stuart, A. (1953). The estimation and comparison of strengths of association
#' in contingency tables.  Biometrika, 40(1/2), 105-110.
"vision_data_men"


#' Agreement between two clinicians on presence of multiple sclerosis
#' based on file.
#'
#' See companion new_orleans_data.
#'
#' @format ## `winnipeg_data`
#' A matrix with 4 rows and 4 columns
#' Ratings range from definite presence of disease to definite absence.
#' @source
#' ???
"winnipeg_data"
