% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_heiss}
\alias{plot_heiss}
\title{Heiss Plot for Predicted Proportions of Bounded Scale Components}
\usage{
plot_heiss(
  object,
  grouping_fac = NULL,
  recode_group_labels = NULL,
  ndraws = NULL,
  show_category_perc_labels = TRUE,
  category_label_font_size = 3,
  category_label_accuracy = 1,
  strip_text_font = element_text(face = "plain", size = 9),
  plot_title = "Predicted Proportions of Bounded Scale Components",
  plot_subtitle = paste0("By Unique Values of ", grouping_fac),
  plot_caption = NULL,
  plot_caption_width = 70,
  calc_func = mean,
  lb = 0.05,
  upb = 0.95,
  plot_font_size = 11,
  plot_font = "",
  y_axis_label = "Predicted Proportions",
  legend_name = "Scale Components",
  component_colors = c("#ef8737", "#bb292c", "#62205f"),
  component_labels = c("0", "(0-1)", "1"),
  ...
)
}
\arguments{
\item{object}{A fitted \code{\link[=ordbetareg]{ordbetareg()}} model object.}

\item{grouping_fac}{A character string indicating the name of the discrete column in the data used for grouping predictions. Must be a valid column name that was passed to \code{\link[=ordbetareg]{ordbetareg()}}.}

\item{recode_group_labels}{Optional. A character vector of new labels for the grouping factor levels. Must match the number and order of unique levels/values in \code{grouping_fac}.}

\item{ndraws}{Optional. The number of posterior draws to use for predictions. If \code{NULL}, all available draws are used.}

\item{show_category_perc_labels}{Logical. Whether to display category percentage labels on the plot. Defaults to \code{TRUE}.}

\item{category_label_font_size}{The \code{ggplot2} font size for the labels on the
scale components (if \code{show_category_perc_labels} is \code{TRUE}). Defaults to 3.}

\item{category_label_accuracy}{The accuracy, or amount of rounding,
for component label ranges on the plot (if \code{show_category_perc_labels} is \code{TRUE}).
Default is 1. See \code{\link[scales:label_percent]{scales::label_percent()}} for more info on meaning of
\code{accuracy} parameter.}

\item{strip_text_font}{A \code{ggplot2::element_text} object defining the font style for facet strip text. Defaults to \code{element_text(face = "plain", size = 9)}.}

\item{plot_title}{Title of the plot. Defaults to "Predicted Proportions of Bounded Scale Components".}

\item{plot_subtitle}{Subtitle of the plot. Defaults to a message indicating the grouping variable.}

\item{plot_caption}{Caption text for the plot. If NULL, the default, will use a detailed but static description of the plot contents.}

\item{plot_caption_width}{Width (in characters) at which the caption is wrapped. Defaults to 60.}

\item{calc_func}{A function used to calculate the central tendency of predictions. Defaults to \code{mean}.}

\item{lb}{Lower bound for uncertainty intervals. Defaults to 0.05 (5th percentile).}

\item{upb}{Upper bound for uncertainty intervals. Defaults to 0.95 (95th percentile).}

\item{plot_font_size}{Base font size for the plot. Defaults to 11.}

\item{plot_font}{Base font family for the plot. Defaults to an empty string (uses system default).}

\item{y_axis_label}{Label for the y-axis. Defaults to "Predicted Proportions".}

\item{legend_name}{Legend title. Defaults to "Scale Components".}

\item{component_colors}{A character vector of colors for the plot components (bottom, continuous, top). Defaults to \code{c("#ef8737", "#bb292c", "#62205f")}.}

\item{component_labels}{A character vector of labels for the scale/outcome components (bottom, continuous, top). Defaults to \code{c("0", "(0-1)", "1")}.}

\item{...}{Additional arguments passed to [posterior_epred_ordbeta())].

[posterior_epred_ordbeta())]: R:posterior_epred_ordbeta())}
}
\value{
A \code{ggplot2} object representing the predicted proportions of the components.
}
\description{
The Heiss plot, developed by the statistician Andrew Heiss, is a plot of the predicted proportions of components on a bounded scale that are grouped by the unique levels of a grouping variable or factor (such as a random effect) in the model.
The plot excels at showing how the scale components--that is, the bottom, middle continuous, and top ends of the scale--vary with a discrete variable while also capturing posterior uncertainty.
This plot was the winner of the 2023 ordbetareg Visualization Prize.
}
\details{
For more details of the plot, see:

Heiss, Andrew and Ye, Meng. "Enforcing Boundaries: China's Overseas NGO Law and Operational Constraints for Global Civil Society." Working Paper, 2023. \url{https://stats.andrewheiss.com/compassionate-clam/notebook/manuscript.html}.
}
\examples{
# Load a fitted model object and create a plot for
# distinct values of the factor education
#
# data('ord_fit_mean')
#
# plot_heiss(ord_fit_mean,ndraws=100)
#
# See introductory package vignette for more information on function options

}
