% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{check_alignment}
\alias{check_alignment}
\title{Check the alignment of harvester and applicator/planter}
\usage{
check_alignment(td)
}
\arguments{
\item{td}{trial design data created by make_exp_plots() and assign_rates()}
}
\value{
a tibble
}
\description{
Check the alignment of harvester and applicator/planter for mixed treatment problems where multiple input rates are associated with yield monitor data
}
\examples{
#--- load trial design ---#
data(td_single_input)

#--- check the alignment of harvester and applicator/planter ---#
machine_alignment <- check_alignment(td_single_input)

#--- check the degree of mixed treatment problem ---#
machine_alignment$overlap_data

#--- visualize the degree of mixed treatment problem ---#
machine_alignment$g_overlap[[1]]
}
