% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_images.R
\name{compare_images}
\alias{compare_images}
\title{Compare Two Images}
\usage{
compare_images(
  img1,
  img2,
  diff_output = NULL,
  threshold = 0.1,
  antialiasing = FALSE,
  fail_on_layout = FALSE,
  ignore_regions = NULL,
  ...
)
}
\arguments{
\item{img1}{Path to the first image, or a magick-image object.}

\item{img2}{Path to the second image, or a magick-image object.}

\item{diff_output}{Path for the diff output image (PNG only). Use \code{NULL}
for no diff output, or \code{TRUE} to auto-generate a temporary file path.}

\item{threshold}{Numeric; color difference threshold between 0.0 and 1.0.
Default is 0.1.}

\item{antialiasing}{Logical; if \code{TRUE}, ignore antialiased pixels.
Default is \code{FALSE}.}

\item{fail_on_layout}{Logical; if \code{TRUE}, fail if images have different
dimensions. Default is \code{FALSE}.}

\item{ignore_regions}{List of regions to ignore during comparison.
Use \code{\link[=ignore_region]{ignore_region()}} to create regions, or pass a data.frame with
columns \code{x1}, \code{y1}, \code{x2}, \code{y2}.}

\item{...}{Additional arguments passed to \code{\link[=odiff_run]{odiff_run()}}.}
}
\value{
A tibble (if available) or data.frame with columns:
\describe{
\item{match}{Logical; \code{TRUE} if images match.}
\item{reason}{Character; comparison result reason.}
\item{diff_count}{Integer; number of different pixels.}
\item{diff_percentage}{Numeric; percentage of different pixels.}
\item{diff_output}{Character; path to diff image, or \code{NA}.}
\item{img1}{Character; path to first image.}
\item{img2}{Character; path to second image.}
}
}
\description{
High-level function for comparing images with convenient output.
Returns a tibble if the tibble package is available, otherwise a data.frame.
Accepts file paths or magick-image objects.
}
\examples{
\dontrun{
# Compare two image files
result <- compare_images("baseline.png", "current.png")
result$match

# With diff output
result <- compare_images("baseline.png", "current.png", diff_output = TRUE)
result$diff_output

# Compare magick-image objects (requires magick package)
library(magick)
img1 <- image_read("baseline.png")
img2 <- image_read("current.png")
result <- compare_images(img1, img2)

# Ignore specific regions
result <- compare_images("baseline.png", "current.png",
                         ignore_regions = list(
                           ignore_region(0, 0, 100, 50),    # Header
                           ignore_region(0, 500, 800, 600)  # Footer
                         ))
}
}
\seealso{
\code{\link[=odiff_run]{odiff_run()}} for the low-level interface,
\code{\link[=ignore_region]{ignore_region()}} for creating ignore regions.
}
