% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.r
\name{box_dist}
\alias{box_dist}
\title{Distance based on side by side Boxplots}
\usage{
box_dist(X, PX)
}
\arguments{
\item{X}{a data.frame with one factor variable and one continuous
variable}

\item{PX}{a data.frame with one factor variable and one continuous
variable}
}
\value{
distance between X and PX
}
\description{
Assuming that data set X consists of a categorical group variable a numeric value,
a summary of the first quartile, median and third quartile of this value is calculated
for each group.
The extent (as absolute difference) of the minimum and maximum value across groups is computed for
first quartile, median and third quartile. Same is done for data PX.
Finally an euclidean distance is calculated between the absolute differences of
X and PX.
}
\examples{
if(require('dplyr')) {
  with(mtcars,
    box_dist(data.frame(as.factor(am), mpg),
    data.frame(as.factor(sample(am)), mpg))
  )
}
}
