#######################################################################
# nuggets: An R framework for exploration of patterns in data
# Copyright (C) 2025 Michal Burda
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <https://www.gnu.org/licenses/>.
#######################################################################


test_that("which_antichain", {
    expect_equal(which_antichain(list()),
                 integer(0))
    expect_equal(which_antichain(list(1, 2, 3)),
                 c(1, 2, 3))
    expect_equal(which_antichain(list(1, 1, 2)),
                 c(1, 3))
    expect_equal(which_antichain(list(c(1, 2, 5), 1, 2, 5, c(5, 2), 7)),
                 c(1, 6))
    expect_equal(which_antichain(list(c(1, 2), c(1, 3), c(4, 2), 1, 2, 3, 4)),
                 c(1, 2, 3))

    expect_equal(which_antichain(list(c(1, 2, 3), c(1, 4), c(1, 2, 5, 6), c(1, 5, 6)),
                                 1),
                 c(1, 4))
})
