% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNotionDatabase.R
\name{getNotionDatabase}
\alias{getNotionDatabase}
\title{Returns a database as a data.frame}
\usage{
getNotionDatabase(
  secret,
  database,
  filters = NULL,
  show_progress = FALSE,
  all_pages = TRUE,
  cover_icon = FALSE
)
}
\arguments{
\item{secret}{Notion API token}

\item{database}{Notion database ID. Use normalizeChromaPageIds if using directly from browser.}

\item{filters}{A list built with filter operators (see filters) to query database. If NULL will query everything.}

\item{show_progress}{show prints of progress?}

\item{all_pages}{download all pages (loop thru paginations)?}

\item{cover_icon}{also include cover and icon metadata?}
}
\value{
data.frame
}
\description{
Query a database in Notion with desired filters and get a database as a data.frame in R or download the entire database (all pages).
}
\details{
This is actually a POST request as per Notions API: https://developers.notion.com/reference/post-database-query
}
\author{
Eduardo Flores
}
