% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extract}
\alias{extract}
\title{Extracts Estimates from the Nonprob Class Object}
\usage{
extract(object, what)
}
\arguments{
\item{object}{object of of the \code{nonprob} class}

\item{what}{what to extract: all estimates (mean(s), SE(s) and CI(s); \code{"all"}; default), estimated mean(s) (\code{"mean"}) or their standard error(s) (\code{"se"})}
}
\value{
a \code{data.frame} with selected information
}
\description{
Returns a \code{data.frame} of estimated mean(s) or standard error(s)
}
\examples{
data(admin)
data(jvs)

jvs_svy <- svydesign(ids = ~ 1,  weights = ~ weight,
strata = ~ size + nace + region, data = jvs)

ipw_est1 <- nonprob(selection = ~ region + private + nace + size,
target = ~ single_shift,
svydesign = jvs_svy,
data = admin, method_selection = "logit"
)
extract(ipw_est1)
extract(ipw_est1, "se")
}
