% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nominatim_check_access.R
\name{api_call}
\alias{api_call}
\title{Helper function for centralize API queries}
\usage{
api_call(url, destfile = tempfile(fileext = ".json"), quiet)
}
\arguments{
\item{url}{a \code{\link{character}} string (or longer vector
    for the \code{"libcurl"} method) naming the URL of a resource to be
    downloaded.}

\item{destfile}{a character string (or vector, see the \code{url}
    argument) with the file path where the downloaded file is to be
    saved.  Tilde-expansion is performed.}

\item{quiet}{If \code{TRUE}, suppress status messages (if any), and
    the progress bar.}
}
\value{
A logical \code{TRUE/FALSE}.
}
\description{
A wrapper of \code{\link[utils:download.file]{utils::download.file()}}. On warning on error it will
retry the call. Requests are adjusted to the rate of 1 query per second.

See \href{https://operations.osmfoundation.org/policies/nominatim/}{Nominatim Usage Policy}.
}
\seealso{
API Management: 
\code{\link{nominatim_check_access}()}
}
\concept{api_management}
\keyword{internal}
