% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gambaryan.R
\name{gambaryan}
\alias{gambaryan}
\title{Gambaryan (GA) Measure}
\usage{
gambaryan(data)
}
\arguments{
\item{data}{A data.frame or a matrix with cases in rows and variables in columns.}
}
\value{
The function returns an object of the class "dist".
\cr
}
\description{
The function calculates a dissimilarity matrix based on the GA similarity measure.
}
\details{
The Gambaryan similarity measure was presented in (Gambaryan, 1964).
The measure assigns low weight to matches where the matching value occurs in about half the dataset, i.e., in between being frequent and rare, see (Borian et al., 2008).
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.gambaryan <- gambaryan(data20)

}
\references{
Gambaryan P. (1964). A mathematical model of taxonomy. 
SSR, 17(12), 47-53.
 \cr
 \cr
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
}
\seealso{
\code{\link[nomclust]{anderberg}},
\code{\link[nomclust]{burnaby}},
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{goodall1}},
\code{\link[nomclust]{goodall2}},
\code{\link[nomclust]{goodall3}},
\code{\link[nomclust]{goodall4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{smirnov}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
