% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_phylogeny.R
\name{infer_phylogeny}
\alias{infer_phylogeny}
\title{infer the time calibrated phylogeny associated with the provided alignment.
This function uses the R package babette to infer the phylogeny using BEAST2.}
\usage{
infer_phylogeny(
  alignment,
  treatment_name,
  tree_prior = beautier::create_bd_tree_prior(),
  clock_prior = beautier::create_strict_clock_model(),
  mcmc_seed = NULL,
  chain_length = 1e+07,
  sample_interval = 5000,
  burnin = 0.1,
  working_dir = NULL,
  sub_rate = 1
)
}
\arguments{
\item{alignment}{Phydat object containing the focal alignment}

\item{treatment_name}{string to be appended to BEAST files}

\item{tree_prior}{tree prior used, default = birth-death prior}

\item{clock_prior}{clock prior used, default = strict clock}

\item{mcmc_seed}{seed of the mcmc chain, default is the system time}

\item{chain_length}{length of the mcmc chain, default is 1e7.}

\item{sample_interval}{interval of sampling, default is 5000}

\item{burnin}{burnin of posterior distribution}

\item{working_dir}{beast2 working dir}

\item{sub_rate}{substitution rate used to generate the original
alignment (if available), default is 1}
}
\value{
list with all trees, and the consensus tree
}
\description{
infer the time calibrated phylogeny associated with the provided alignment.
This function uses the R package babette to infer the phylogeny using BEAST2.
}
