% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmi_svd.R
\name{get_pmi}
\alias{get_pmi}
\title{Compute pointwise mutual information (PMI)}
\usage{
get_pmi(spm_cooc)
}
\arguments{
\item{spm_cooc}{Co-occurrence sparse matrix, either a triangular sparse
matrix or a dataframe}
}
\value{
PMI symmetric matrix
}
\description{
Compute pointwise mutual information (PMI)
}
\examples{
df_ehr = data.frame(Patient = c(1, 1, 2, 1, 2, 1, 1, 3, 4),
                    Month = c(1, 1, 1, 2, 2, 3, 3, 4, 4),
                    Parent_Code = c('C1', 'C2', 'C2', 'C1', 'C1', 'C1',
                                    'C2', 'C3', 'C4'),
                    Count = 1:9)

spm_cooc = build_df_cooc(df_ehr)

m_pmi = get_pmi(spm_cooc)

}
