% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/force_find_lambdaz.R
\name{force_find_lambdaz}
\alias{force_find_lambdaz}
\title{Forceful estimation of terminal slope}
\usage{
force_find_lambdaz(time, conc, ...)
}
\arguments{
\item{time}{Numeric vector of time points.}

\item{conc}{Numeric vector of concentration values corresponding to time.}

\item{...}{Additional arguments passed to find_best_lambdaz (e.g., nlastpoints).}
}
\value{
A list containing:
\itemize{
\item lambdaz: Estimated terminal elimination rate constant (1/time)
\item intercept: Intercept of the log-linear regression, used to extrapolate concentration at time zero
\item method: Method used (\code{find_best_lambdaz} or fallback regression)
\item UsedPoints: Number of time-concentration points used for estimation
\item adj.r.squared: Adjusted R-squared (available only when using \code{find_best_lambdaz})
\item message: Diagnostic message summarizing the outcome
\item slopefit: Fitted linear model object
}
}
\description{
Estimates the terminal elimination rate constant (lambda_z) of a pharmacokinetic
profile. The function first attempts to use the \code{find_best_lambdaz} method. If no
valid estimate is obtained, it falls back to a simplified log-linear regression
using progressively fewer data points to enforce a negative slope.
}
\details{
This function implements a two-step strategy to ensure estimation of the
terminal elimination slope:
\itemize{
\item First, it applies \code{find_best_lambdaz} to automatically select the best
fitting terminal phase segment based on adjusted R-squared optimization.
\item If \code{find_best_lambdaz} fails (e.g., limited data), the function forcibly
fits simplified linear models using progressively fewer points (starting
from n-1 down to 2) until a negative slope is identified. In fallback
mode, adjusted R-squared is not considered.
}
}
\examples{
time <- c(0.5, 1, 2, 4, 6, 8, 10)
conc <- c(12, 8, 5, 3, 2, 1.5, 1)
force_find_lambdaz(time, conc)

}
\seealso{
\link{find_best_lambdaz}
}
\author{
Zhonghui Huang
}
