% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materncov2.R
\name{materncov2}
\alias{materncov2}
\title{Matern Covariance kernel with \eqn{\nu = 5/2}}
\usage{
materncov2(dists, phi, sigma2, tau2)
}
\arguments{
\item{dists}{distance matrix}

\item{phi}{spatial range}

\item{sigma2}{spatial variance}

\item{tau2}{nugget variance}
}
\value{
A matrix of covariance terms. For internal use only.
}
\description{
Computes the Matern covariance matrix with fractal parameter \eqn{\nu = 5/2}.
Has the option to compute \eqn{\Sigma_{d\times d} + \tau^2 I_d}.
}
\examples{
\donttest{
#####################
# Internal use only #
#####################
# Used across multiple functions
# Example usage
require(nimble)
require(nimblewomble)

set.seed(1)
# Generated Simulated Data
N = 1e2
tau = 1
coords = matrix(runif(2 * N, -10, 10), ncol = 2)
colnames(coords) = c("x", "y")
dists = as.matrix(dist(coords))

cMaterncov1  = compileNimble(materncov1)
cMaterncov1(dists = dists[1:N, 1:N], phi = 1, sigma2 = 1, tau2 = 0)
}
}
\author{
Aritra Halder <aritra.halder@drexel.edu>, \cr
Sudipto Banerjee <sudipto@ucla.edu>
}
\keyword{materncov2}
