% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPriors.R
\name{matchPrior}
\alias{matchPrior}
\title{Match a prior from a list of prior settings}
\usage{
matchPrior(parName, ..., priors)
}
\arguments{
\item{parName}{Parameter to get a prior for, as quoted code/name, possibly
including brackets/indices}

\item{...}{Character strings that categorize the parameter and match
the names of elements in \code{priors}. The order is important:
the first match found is used.}

\item{priors}{A named list of prior settings, e.g., as generated by
\code{setPriors}}
}
\value{
NIMBLE code for the matching prior.
}
\description{
Attempts to determine which prior to put on a parameter based on a list of settings,
such as the output from \code{setPriors()}. The function follows the following
search pattern: (1) looks for an exact match to the parameter name including brackets;
(2) a match to the parameter name without brackets; (3) goes through each value
supplied to \code{...} in order and looks for a match in the names of the
settings list. Once a match is found the function returns the corresponding
prior value.
}
\examples{
pr <- setPriors(intercept = quote(dunif(-3, 3)), 'alpha' = quote(dunif(0,1)), 
                'alpha[2]' = "dnorm(0, 3)")
matchPrior(quote(alpha), priors=pr)
matchPrior(quote(alpha[2]), priors=pr)
matchPrior(quote(intercept), priors=pr)

}
\author{
Ken Kellner
}
