% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_intensity_line.R
\name{draw_intensity_line}
\alias{draw_intensity_line}
\title{Simulate from a non homogeneous Poisson Point Process (NHPPP) from
(t0, t_max) (thinning method)}
\usage{
draw_intensity_line(
  lambda,
  majorizer_intercept,
  majorizer_slope,
  t_min,
  t_max,
  majorizer_is_loglinear = FALSE,
  atmost1 = FALSE
)
}
\arguments{
\item{lambda}{(function) the instantaneous rate of the NHPPP.}

\item{majorizer_intercept}{(double) the intercept (\code{alpha}) of the \link{log}linear majorizer function.}

\item{majorizer_slope}{(double) the slope (`beta') of the \link{log}linear majorizer function.}

\item{t_min}{(double) the lower bound of the time interval.}

\item{t_max}{(double) the upper bound of the time interval.}

\item{majorizer_is_loglinear}{(boolean) if \code{TRUE} the majorizer is loglinear \code{exp(alpha + beta * t)}}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times (t_); if no events realize,
a vector of length 0
}
\description{
Sample NHPPP times using the thinning method
}
\keyword{internal}
