% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yth_glm.R
\name{yth_glm}
\alias{yth_glm}
\title{Fits Hamilton's alternative model}
\usage{
yth_glm(x, h = 8, p = 4, ...)
}
\arguments{
\item{x}{A univariate \code{\link[xts]{xts}} object of any
\code{\link[zoo]{zoo}} index class, such as \code{\link[base]{Date}},
\code{\link[zoo]{yearmon}}, or \code{\link[zoo]{yearqtr}}.
For converting objects of type \code{timeSeries}, \code{ts}, \code{irts},
\code{fts}, \code{matrix}, \code{data.frame}, or \code{\link[zoo]{zoo}}
to \code{\link[xts]{xts}}, please see \code{\link[xts]{as.xts}}.}

\item{h}{An \code{integer}, defining the lookahead period. Defaults to
\code{h = 8}, suggested by Hamilton. The default assumes economic data of
quarterly periodicity with a lookahead period of 2 years. This function is
not limited by the default parameter, and econometricians may change it as required.}

\item{p}{An \code{integer}, indicating the number of lags. A default of
\code{p = 4}, suggested by Hamilton, assumes data is of quarterly periodicity.
If data is monthly, one may choose \code{p = 12} or aggregate the series
to quarterly and maintain the default. Econometricians should use this
parameter to accommodate the seasonality of their data.}

\item{...}{Additional arguments passed to \code{\link[stats]{glm}}.}
}
\value{
\code{yth_glm} returns a generalized linear model object of class
\code{\link[stats]{glm}}, which inherits from \code{\link[stats]{lm}}.
}
\description{
\code{yth_glm} fits a generalized linear model suggested by James D. Hamilton
as a better alternative to the Hodrick-Prescott Filter.
}
\details{
For time series of quarterly periodicity, Hamilton suggests parameters of
h = 8 and p = 4, or an \eqn{AR(4)} process, additionally lagged by \eqn{8}
lookahead periods. Econometricians may explore variations of h. However, p is
designed to correspond with the seasonality of a given periodicity and should
be matched accordingly.
}
\examples{
data(GDPC1)

gdp_model <- yth_glm(GDPC1, h = 8, p = 4, family = gaussian)

summary(gdp_model)

plot(gdp_model)

}
\references{
James D. Hamilton.
\href{http://econweb.ucsd.edu/~jhamilto/hp.pdf}{Why You Should Never Use the Hodrick-Prescott Filter}.
NBER Working Paper No. 23429, Issued in May 2017.
}
\seealso{
\code{\link[stats]{glm}}, \code{\link[stats]{lm}}
}
