% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCECC96.R
\docType{data}
\name{PCECC96}
\alias{PCECC96}
\title{Real Personal Consumption Expenditures}
\format{
An \code{\link[xts]{xts}} object containing quarterly observations of
Real Personal Consumption Expenditures.
\describe{
  \item{**Release:**}{Gross Domestic Product}
  \item{**Seasonal Adjustment:**}{Seasonally Adjusted Annual Rate}
  \item{**Frequency:**}{Quarterly}
  \item{**Units:**}{Billions of Chained 2017 Dollars}
  \item{**Date Range:**}{1947-01-01 to 2025-04-01}
}
}
\source{
U.S. Bureau of Economic Analysis \url{https://fred.stlouisfed.org/data/PCECC96}
}
\usage{
data(PCECC96)
}
\description{
\code{PCECC96} Real Personal Consumption Expenditures
}
\section{Notes}{

BEA Account Code: DPCERX

A Guide to the National Income and Product Accounts of the United States (NIPA)
- (http://www.bea.gov/national/pdf/nipaguid.pdf)
}

\examples{
data(PCECC96)
tail(PCECC96)
plot(PCECC96, grid.col = "white", col = "blue")
}
\keyword{datasets}
