% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gn_nidp.R
\name{plot_gnNIDP}
\alias{plot_gnNIDP}
\title{Gene by NIDP summary plot of neuroimaGene object}
\usage{
plot_gnNIDP(
  ng_obj,
  maxNidps = 20,
  maxGns = 15,
  title = NA,
  shortnames = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{ng_obj}{NeuroimaGene object}

\item{maxNidps}{maximum number of NIDPs to visualize. default=20}

\item{maxGns}{maximum number of genes to visualize. default=15}

\item{title}{optional title tag for the plot}

\item{shortnames}{optional boolean tag for simplified names. Default to TRUE}

\item{verbose}{print runtime messages to R console. Default to FALSE}
}
\value{
a ggplot class heatmap showing tissue models per NIDP/Gene pair
}
\description{
Generate overview plot of the neuroimagene object according to gene/NIDP pair
}
\examples{
gene_list <- c('TRIM35', 'PROSER3', 'EXOSC6', 'PICK1', 'UPK1A', 'ESPNL', 'ZIC4')
ng <- neuroimaGene(gene_list, atlas = NA, mtc = 'BH', vignette = TRUE)
plot_gnNIDP(ng)

}
\keyword{neuroimaging}
