% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurovec.R, R/neurovecseq.R,
%   R/roi.R, R/sparse_neurovec.R
\name{vectors}
\alias{vectors}
\alias{vectors,NeuroVec,missing-method}
\alias{vectors,DenseNeuroVec,missing-method}
\alias{vectors,NeuroVec,numeric-method}
\alias{vectors,NeuroVec,logical-method}
\alias{vectors,NeuroVecSeq,missing-method}
\alias{vectors,NeuroVecSeq,numeric-method}
\alias{vectors,NeuroVecSeq,logical-method}
\alias{vectors,ROIVec,missing-method}
\alias{vectors,matrix,missing-method}
\alias{vectors,ROIVec,integer-method}
\alias{vectors,matrix,integer-method}
\alias{vectors,matrix,numeric-method}
\alias{vectors,ROIVec,numeric-method}
\alias{vectors,ROIVec,logical-method}
\alias{vectors,SparseNeuroVec,missing-method}
\title{Extract an ordered list of 1D vectors.}
\usage{
vectors(x, subset, ...)

\S4method{vectors}{NeuroVec,missing}(x)

\S4method{vectors}{DenseNeuroVec,missing}(x)

\S4method{vectors}{NeuroVec,numeric}(x, subset)

\S4method{vectors}{NeuroVec,logical}(x, subset)

\S4method{vectors}{NeuroVecSeq,missing}(x)

\S4method{vectors}{NeuroVecSeq,numeric}(x, subset)

\S4method{vectors}{NeuroVecSeq,logical}(x, subset)

\S4method{vectors}{ROIVec,missing}(x)

\S4method{vectors}{matrix,missing}(x)

\S4method{vectors}{ROIVec,integer}(x, subset)

\S4method{vectors}{matrix,integer}(x, subset)

\S4method{vectors}{matrix,numeric}(x, subset)

\S4method{vectors}{ROIVec,numeric}(x, subset)

\S4method{vectors}{ROIVec,logical}(x, subset)

\S4method{vectors}{SparseNeuroVec,missing}(x, nonzero = FALSE)
}
\arguments{
\item{x}{the object that supplies the vector data.}

\item{subset}{the subset of vectors to extract.}

\item{...}{additional arguments to be passed to methods.}

\item{nonzero}{only include nonzero vectors in output list}
}
\value{
A \code{list} containing the extracted vectors from \code{x} in the same order as \code{subset}.

A deflist object where each element is a function that returns the time series
        for a voxel. The length of the deflist equals the total number of voxels.
}
\description{
This function extracts an ordered list of 1D vectors from an object that supplies vector data.
The \code{subset} argument specifies the subset of vectors to extract, and can be a vector
of indices or a logical vector. The return value is a list containing the extracted vectors
in the same order as the specified indices.
}
\examples{

file_name <- system.file("extdata", "global_mask_v4.nii", package="neuroim2")
vec <- read_vec(file_name)
v <- vectors(vec)
mean(v[[1]])
}
