% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurovec.R
\name{split_blocks}
\alias{split_blocks}
\alias{split_blocks,NeuroVec,integer-method}
\alias{split_blocks,NeuroVec,factor-method}
\title{Cut a vector-valued object into a list of sub-blocks}
\usage{
split_blocks(x, indices, ...)

\S4method{split_blocks}{NeuroVec,integer}(x, indices, ...)

\S4method{split_blocks}{NeuroVec,factor}(x, indices, ...)

\S4method{split_blocks}{NeuroVec,factor}(x, indices, ...)
}
\arguments{
\item{x}{a vector-valued object}

\item{indices}{a vector of indices defining the sub-blocks. Must match the length of the input vector.}

\item{...}{additional arguments}
}
\value{
A \code{list} of sub-blocks, where each sub-block contains the elements from \code{x} corresponding to the matching \code{indices}.
}
\description{
Splits a vector-valued object into a list of sub-blocks defined by a vector of indices.
}
\examples{
# Create a 4D neuroimaging vector with 20 timepoints
space <- NeuroSpace(c(10,10,10,20), c(1,1,1))
vec <- NeuroVec(array(rnorm(10*10*10*20), c(10,10,10,20)), space)

# Split into 4 blocks by assigning timepoints to blocks 1-4 repeatedly
block_indices <- rep(1:4, length.out=20)
blocks <- split_blocks(vec, block_indices)

}
