% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{series_roi}
\alias{series_roi}
\title{Extract time series from specific voxel coordinates and return as ROI object}
\usage{
series_roi(x, i, ...)
}
\arguments{
\item{x}{The \code{NeuroVec} object}

\item{i}{Numeric index for the first dimension}

\item{...}{Additional arguments}
}
\value{
A \code{ROIVec} object containing the time series data for the specified coordinates.
}
\description{
Extracts time series data from a \code{NeuroVec} object at specified voxel coordinates
and returns it as an ROI object.
}
\examples{
# Create a simple 4D neuroimaging vector
space <- NeuroSpace(c(10,10,10,20), c(1,1,1))
vec <- NeuroVec(array(rnorm(10*10*10*20), c(10,10,10,20)), space)

# Extract time series for first 100 voxels as ROI
roi1 <- series_roi(vec, 1:100)

# Extract time series using 3D coordinates
coords <- matrix(c(1,1,1, 2,2,2, 3,3,3), ncol=3, byrow=TRUE)
roi2 <- series_roi(vec, coords)
}
\seealso{
\code{\link{series}}
}
