% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_vol.R, R/roi.R, R/sparse_neurovec.R
\name{indices,IndexLookupVol-method}
\alias{indices,IndexLookupVol-method}
\alias{indices,ROIVol-method}
\alias{indices,ROIVec-method}
\alias{indices,AbstractSparseNeuroVec-method}
\title{Get Indices from an IndexLookupVol Object}
\usage{
\S4method{indices}{IndexLookupVol}(x)

\S4method{indices}{ROIVol}(x)

\S4method{indices}{ROIVol}(x)

\S4method{indices}{ROIVec}(x)

\S4method{indices}{AbstractSparseNeuroVec}(x)
}
\arguments{
\item{x}{An \code{\linkS4class{IndexLookupVol}} object}
}
\value{
the indices of the lookup volume
}
\description{
Retrieves the vector of indices that are included in the lookup volume.
}
\examples{

space <- NeuroSpace(c(64, 64, 64), c(1, 1, 1), c(0, 0, 0))
ilv <- IndexLookupVol(space, c(1:100))
idx <- indices(ilv)  # Get included indices


}
