% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_info.R
\name{data_reader}
\alias{data_reader}
\title{Create a Data Reader}
\usage{
data_reader(x, offset)
}
\arguments{
\item{x}{An object containing metadata required to create the reader (e.g., file path, format info)}

\item{offset}{Numeric. Byte offset where data reading should begin. Default is 0.}
}
\value{
A BinaryReader object configured for the specific data format
}
\description{
Creates a data reader for accessing neuroimaging data from various file formats.
  The reader provides a unified interface for reading data regardless of the underlying format.
}
\details{
Create a Data Reader for Neuroimaging Data


The data_reader function is a generic that creates appropriate readers for different
neuroimaging formats. It handles:
\itemize{
  \item File format detection and validation
  \item Endianness configuration
  \item Data type conversion
  \item Compression handling (e.g., gzip)
  \item Proper byte alignment
}
}
\examples{

# Create reader for NIFTI file
meta <- read_header(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))
reader <- data_reader(meta, offset = 0)

# Read first 100 voxels
data <- read_elements(reader, 100)


}
\seealso{
\code{\link{read_header}} for reading headers,
\code{\linkS4class{BinaryReader}} for reading binary data
}
