% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/file_format.R
\name{data_file}
\alias{data_file}
\alias{data_file,FileFormat,character-method}
\title{Generic function to get the name of the data file, given a file name and a \code{\linkS4class{FileFormat}} instance.}
\usage{
data_file(x, file_name)

\S4method{data_file}{FileFormat,character}(x, file_name)
}
\arguments{
\item{x}{A \linkS4class{FileFormat} object specifying the format requirements}

\item{file_name}{A character string specifying the file name to derive the data
file name from}
}
\value{
The correct data file name as a \code{character} string.

A character string representing the data file name
}
\description{
Derives the data file name from a given file name based on the FileFormat
specifications.
}
\details{
The function performs the following steps:
\enumerate{
  \item If the input file_name already matches the data file format, it returns
    the file_name as is.
  \item If the file_name matches the header file format, it constructs and returns
    the corresponding data file name.
  \item If the file_name doesn't match either format, it throws an error.
}
}
\examples{

fmt <- new("FileFormat", header_extension = "hdr", data_extension = "img")
data_file(fmt, "brain_scan.img")  # Returns "brain_scan.img"
data_file(fmt, "brain_scan.hdr")  # Also Returns "brain_scan.img"


}
\seealso{
\code{\link{header_file}}, \code{\link{strip_extension}} for related file name
manipulation
}
