% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R, R/filebacked_neurovec.R
\docType{class}
\name{FileBackedNeuroVec-class}
\alias{FileBackedNeuroVec-class}
\title{FileBackedNeuroVec Class}
\description{
A class representing a four-dimensional brain image that uses on-demand loading
through memory-mapped file access. This approach enables efficient handling of
large-scale brain imaging data by loading only the required portions of the data
into memory when needed.

The \code{FileBackedNeuroVec} class represents a memory-efficient vector of neuroimaging data
that is stored on disk rather than in memory. This is particularly useful for large datasets
where memory constraints are a concern.
}
\details{
FileBackedNeuroVec objects provide a memory-efficient solution for working with
large 4D neuroimaging datasets. By utilizing memory-mapped file access, this class
allows users to work with datasets that exceed available RAM, only loading the
necessary data segments into memory as they are accessed.
}
\section{Slots}{

\describe{
\item{\code{meta}}{An instance of class \code{\linkS4class{FileMetaInfo}} containing
file metadata such as file path, format, and other associated information.}
}}

\section{Inheritance}{

\code{FileBackedNeuroVec} inherits from:
\itemize{
  \item \code{\linkS4class{NeuroVec}}: Base class for 4D brain images
  \item \code{ArrayLike4D}: Interface for 4D array-like operations
}
}

\section{Memory Management}{

Data is read from disk on-demand, reducing memory usage compared to in-memory storage.
The trade-off is slightly slower access times due to disk I/O operations.
}

\examples{
# Load example 4D image file included with package
file_path <- system.file("extdata", "global_mask_v4.nii", package = "neuroim2")
fbvec <- FileBackedNeuroVec(file_path)

# Get dimensions of the image
dim(fbvec)

# Extract first volume
vol1 <- sub_vector(fbvec, 1)

# Extract multiple volumes
vols <- sub_vector(fbvec, 1:2)

}
\seealso{
\code{\link{NeuroVec-class}} for the base 4D brain image class.
\code{\link{FileMetaInfo-class}} for details on file metadata representation.

\code{\link{FileBackedNeuroVec}} for creating instances of this class
}
