% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatePoissonClones.R
\name{generatePoissonClones}
\alias{generatePoissonClones}
\title{Generate Synthetic Poisson Clones for PET Data}
\usage{
generatePoissonClones(originalMatrix, numClones, lambdaFactor)
}
\arguments{
\item{originalMatrix}{A numeric matrix where each row represents a flattened PET image.}

\item{numClones}{An integer specifying the number of synthetic clones to generate.}

\item{lambdaFactor}{A positive numeric value that scales the magnitude of Poisson noise.}
}
\value{
A numeric matrix with \code{numClones} rows, each representing a noisy version
        of \code{originalMatrix} with Poisson noise added.
}
\description{
Generates synthetic clones of a PET data matrix by adding Poisson-distributed
noise to each non-zero voxel. This approach helps address the limitations of functional
data analysis (FDA) in single-subject versus group (1 vs. Group) setups, where a single subject
lacks sufficient variability to reliably estimate Simultaneous Confidence Corridors (SCCs).
}
\details{
\itemize{
  \item Values equal to \code{0} remain unchanged to preserve background regions.
  \item \code{NA} values are replaced with \code{0} before adding noise.
  \item Poisson noise is applied only to positive values, scaled by \code{lambdaFactor}.
  \item Enables valid SCC estimation in single-subject settings by artificially increasing sample size.
}
}
\examples{
# Load example input matrix for Poisson cloning
data("generatePoissonClonesExample", package = "neuroSCC")
# Select 10 random voxel positions for display
set.seed(123)
sampledCols <- sample(ncol(generatePoissonClonesExample), 10)
# Generate 1 synthetic clone
clones <- generatePoissonClones(generatePoissonClonesExample, numClones = 1, lambdaFactor = 0.25)
# Show voxel intensity values after cloning
clones[, sampledCols]

}
