% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freeman.R
\name{freeman}
\alias{freeman}
\alias{freeman.table}
\alias{freeman.igraph}
\alias{freeman.default}
\title{Generalized Freeman's segregation index}
\usage{
freeman(object, ...)

\method{freeman}{table}(object, gsizes = NULL, loops = FALSE, ...)

\method{freeman}{igraph}(object, vattr, gsizes = NULL, loops = any(which_loop(object)), ...)

\method{freeman}{default}(object, ...)
}
\arguments{
\item{object}{R object, see Details for available methods}

\item{...}{other arguments passed to/from other methods}

\item{gsizes}{numeric, optional true distribution of types, see Details}

\item{loops}{logical, whether loops are allowed}

\item{vattr}{character scalar or any vector of length equal to
\code{vcount(object)}, name of the vertex attribute in \code{object}
designating the groups or a vector with the attribute itself}
}
\value{
The value of the Freeman's index.
}
\description{
Calculate Freeman's segregation index for undirected networks with
arbitrary number of groups.
}
\details{
Freeman's segregation index (Freeman, 1978) is designed to capture the
extent to which the defined groups of vertices tend to have more edges with
vertices from the same group than with other groups.  Formally, the index
compares the observed number of between-group ties with the number of
between-group ties that would be expected if ties would be created randomly.

Originally the index has a discontinuity for network and group size
configurations that are characterized by the higher number of between-group
ties that is expected under a random graph, for which it returns 0 (as
originally described by Freeman (1978)). We removed that truncation such that
it returns values betweem -1 and 1.

The original Freeman's formulation involves two groups of vertices. Here
it is extended to the arbitrary number of groups. The generalization
affects the way in which the expected number of between-group edges under pure
random graph is calculated, see Bojanowski & Corten (2014) for details.

The function internally calculates the sizes of groups of vertices in the
supplied attribute \code{vattr}. However, it is possible to override this by
specifying "true" type distribution with the \code{gsizes} argument. It is assumed
to be a table (as returned by \code{\link[=table]{table()}}) or a numeric vector with the group
sizes. This may be especially usefull when dealing with large graphs and/or
with large number of isolates.

If \code{object} is a table it is interpreted as a mixing matrix.
Two-dimensional table is interpreted as a contact layer. Three-dimensional
table is interpreted as a full mixing matrix \eqn{m_{ghy}}{m[ghy]}
cross-classyfying all dyads, in which \eqn{g} and \eqn{h} correspond to
group membership of ego and alter respectively. Layers \eqn{y=1} and
\eqn{y=2} are assumed to be non-contact and contact layers respectively.

If \code{object} is of class "igraph" it is required to supply \code{vattr}
with the name of the vertex attribute to calculate intermediate mixing
matrix.

Method for mixing matrices

Method for "igraph"s
}
\examples{

## White's data from Freeman's article segregation level
freeman(WhiteKinship, "gender")

# using 'more' argument
freeman(WhiteKinship, "gender")
}
\references{
Freeman, Linton C. (1978) Segregation in Social Networks,
\emph{Sociological Methods & Research} \bold{6}(4):411--429

Bojanowski, Michał, and Rense Corten. 2014. "Measuring Segregation in
Social Networks." \emph{Social Networks} 39: 14–32.
\doi{10.1016/j.socnet.2014.04.001}
}
\seealso{
Other segregation measures: 
\code{\link{assort}()},
\code{\link{coleman}()},
\code{\link{ei}()},
\code{\link{gamix}()},
\code{\link{orwg}()},
\code{\link{smi}()},
\code{\link{ssi}()}
}
\concept{segregation measures}
\keyword{graphs}
