% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot.countries}
\alias{plot.countries}
\title{Basic plot function for \code{countries} objects}
\usage{
\method{plot}{countries}(
  x,
  ...,
  labels = NULL,
  fill = NULL,
  capital = NULL,
  centroid = NULL,
  bks = NULL,
  n = 6,
  style = NULL,
  palette = NULL,
  bw = FALSE
)
}
\arguments{
\item{x}{a \code{countries} object,}

\item{\dots}{further arguments (currently unused)}

\item{labels}{a character vector containing the variables that
should be labeled: \code{country}, \code{capital} and/or \code{towns}}

\item{fill}{a variable use to fill countries' polygons}

\item{capital, centroid}{a variable associated with the shape or the
size of points}

\item{bks}{an optional vector of breaks in order to use a
continuous variable for fill}

\item{n}{the number of class (passed to \code{classIntervals})}

\item{style}{the style (passed to \code{classIntervals})}

\item{palette}{the palette (selected in \code{scale_fill_brewer})}

\item{bw}{a boolean, if \code{TRUE}, a black and white map is produced}
}
\value{
a \code{gg} object.
}
\description{
As the \code{plot} method of \code{sf}, this function is intended to obtain
quickly a map for a set of countries. Countries' boundaries are
represented and filling can be used, some cities can also be
represented and labels can be added. \code{ggplot} is used and should be
used directly when more enhanced maps are required
}
\examples{
we <- countries("Western Europe")
plot(we)
}
