% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndjson.R
\name{stream_in}
\alias{stream_in}
\title{Stream in & flatten an ndjson file into a \code{data.table}}
\usage{
stream_in(path, cls = c("dt", "tbl"))
}
\arguments{
\item{path}{path to file (supports "\code{gz}" files)}

\item{cls}{the package uses \code{data.table::rbindlist} for speed but
that's not always the best return type for everyone, so you have
option of keeping it a \code{data.table} or converting it to a \code{tbl}}
}
\value{
\code{data.table} or \code{tbl}
}
\description{
Given a file of streaming JSON (ndjson) this function reads in the records
and creates a flat \code{data.table} / \code{tbl} from it.
}
\examples{
f <- system.file("extdata", "test.json", package="ndjson")
nrow(stream_in(f))

gzf <- system.file("extdata", "testgz.json.gz", package="ndjson")
nrow(stream_in(gzf))
}
\references{
\url{https://ndjson.org/}
}
