% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InferenceFunctions.R
\name{classic.neyman}
\alias{classic.neyman}
\title{Classic Neyman Sample Average Treatment Effect Estimator}
\usage{
classic.neyman(Y, Z, pairs)
}
\arguments{
\item{Y}{a 2I-length vector of outcome values, which must be numeric.}

\item{Z}{a 2I-length vector of treatment values, which must be numeric.}

\item{pairs}{an I x 2 dataframe containing the indices of observations
that form our set of matched pairs. An appropriate pairs dataframe can be
formed using the \link[nbpInference]{nbp.caliper} function.}
}
\value{
the sample average treatment effect (numeric)
}
\description{
This function estimates the sample average treatment effect for a set of
matched pairs using the classic Neyman estimator. For references on the
classic Neyman estimator, see \insertCite{baiocchi2010building,zhang2022bridging,heng2023instrumental;textual}{nbpInference}
}
\examples{
set.seed(12345)
X <- rnorm(100, 0, 5)
Z <- X + rnorm(100, 0, (1+sqrt(abs(X))))
Y <- X + Z + rnorm(100, 0, 0.5)
pmat <- make.pmatrix(Z, X)
pairs <- nbp.caliper(Z, X, pmat, xi = 0.1, M = 10000)
classic.neyman(Y, Z, pairs)
}
\seealso{
Other inference: 
\code{\link{bias.corrected.neyman}()},
\code{\link{covAdj.variance}()},
\code{\link{make.pmatrix}()},
\code{\link{nbp.caliper}()}
}
\concept{inference}
