% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_narfima_class.R
\name{forecast_narfima_class}
\alias{forecast_narfima_class}
\title{Forecasting from NARFIMA-class Models}
\usage{
forecast_narfima_class(
  object,
  h = ifelse(object$m > 1, 2 * object$m, 10),
  PI = FALSE,
  level = 80,
  fan = FALSE,
  bootstrap = FALSE,
  npaths = 1000,
  innov = NULL,
  xreg = NULL,
  lambda = object$lambda,
  lambdae = object$lambdae,
  ...
)
}
\arguments{
\item{object}{An object of class "narfima".}

\item{h}{Number of periods to forecast. If \code{xreg} is provided, \code{h} is ignored and the forecast horizon is determined by the number of rows in \code{xreg}.}

\item{PI}{Logical value indicating whether to compute prediction intervals (default is \code{FALSE}).}

\item{level}{Confidence level for prediction intervals (default is \code{80}), ignored when \code{PI = FALSE}.}

\item{fan}{If \code{TRUE} (default is \code{FALSE}), level is set to \code{seq(51, 99, by = 3)}. This is suitable for fan plots.}

\item{bootstrap}{Logical value indicating whether to use bootstrapping for prediction intervals (default is \code{FALSE}), ignored when \code{PI = FALSE}.}

\item{npaths}{Number of simulation paths for prediction intervals (default is \code{1000}), ignored when \code{PI = FALSE}.}

\item{innov}{An optional vector of innovations to use for simulating future values (default is \code{NULL}). If \code{NULL} and \code{PI = TRUE}, random innovations are generated.}

\item{xreg}{An optional matrix or data frame of exogenous variables to be used in forecasting (default is \code{NULL}).}

\item{lambda}{Numeric value for the Box-Cox transformation parameter of \code{y} (default is taken from the fitted model, i.e., \code{object$lambda}).}

\item{lambdae}{Numeric value for the Box-Cox transformation parameter of \code{er} (default is taken from the fitted model, i.e., \code{object$lambdae}).}

\item{...}{Additional arguments passed to \code{pred_interval_narfima}.}
}
\value{
An object of class "forecast" containing:
\item{mean}{The point forecasts.}
\item{lower}{The lower bounds of the prediction intervals.}
\item{upper}{The upper bounds of the prediction intervals.}
\item{level}{The confidence level for the prediction intervals.}
\item{model}{The fitted NARFIMA model.}
\item{series}{The name of the input series.}
\item{method}{A string describing the model parameters.}
\item{y}{The input time series.}
\item{e}{The transformed residual series}
}
\description{
This function produces forecasts from fitted models of class \code{narfima}, including NARFIMA, NARIMA, NBSTS, and NNaive. Multi-step forecasts are computed recursively. Prediction intervals can also be obtained through simulation.
}
\examples{
h <- 3

data <- EuStockMarkets[(nrow(EuStockMarkets) - 83):nrow(EuStockMarkets), 3]

train <- data[1:(length(data) - h)]
test <- data[(length(data) - h + 1):length(data)]

narfima_model <- auto_narfima(train)
narfima_forecast <- forecast_narfima_class(narfima_model, h)

}
