% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes_and_generics.R
\name{new_mvalpha}
\alias{new_mvalpha}
\title{Create new mvalpha class object}
\usage{
new_mvalpha(
  mvalpha,
  type,
  mvDo,
  mvDe,
  bootstrap_mvalpha,
  unique_cardinalities,
  units,
  observers,
  labels,
  values,
  values_by_unit,
  dist_CK,
  p_CK,
  data
)
}
\arguments{
\item{mvalpha}{Multi-valued alpha estimate}

\item{type}{a string describing the data type of the label set. This can be "nominal",
"ordinal", "interval", or "ratio" and is used to select the appropriate distance metric.}

\item{mvDo}{Observed disagreement}

\item{mvDe}{Expected disagreement}

\item{bootstrap_mvalpha}{Bootstrap estimates of mvalpha}

\item{unique_cardinalities}{Numeric vector of the unique cardinalities observed in the data}

\item{units}{Names of units}

\item{observers}{Names of observers}

\item{labels}{Unique labels used in data}

\item{values}{Unique values used in data}

\item{values_by_unit}{Table of values by unit}

\item{dist_CK}{Distance matrix for label sets C and K}

\item{p_CK}{Probability matrix for label sets C and K}

\item{data}{a data frame containing a list column for each observer. Each row represents
an observation unit, and each cell contains a vector of 0 to \code{w} unique values, where \code{w} is the
number of unique values found in the data set. \code{NA} values are used to represent
missing observations and \code{NULL} values represent the empty set, \code{{}}, of responses.}
}
\value{
an mvalpha object
}
\description{
Wrapper for creating mvalpha class object.
}
