% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{modelDiagnostics.lme}
\alias{modelDiagnostics.lme}
\title{modelDiagnostics method for lme objects}
\usage{
\method{modelDiagnostics}{lme}(
  object,
  ev.perc = 0.001,
  robust = FALSE,
  distr = "normal",
  standardized = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted model object from \code{\link[nlme]{lme}}.}

\item{ev.perc}{A real number between 0 and 1 indicating the
proportion of the theoretical distribution beyond which
values are considered extreme values (possible outliers).
Defaults to .001.}

\item{robust}{Whether to use robust mean and standard deviation estimates
for normal distribution}

\item{distr}{A character string given the assumed distribution.
Passed on to \code{\link[JWileymisc]{testDistribution}}.
Defaults to \dQuote{normal}.}

\item{standardized}{A logical whether to use standardized pearson residuals.
Defaults to \code{TRUE} generally where possible but may depend on
method.}

\item{...}{Additional arguments, passed to \code{\link[JWileymisc]{residualDiagnostics}}.}
}
\value{
A logical (\code{\link[JWileymisc]{is.modelDiagnostics}}) or
  a modelDiagnostics object (list) for
  \code{\link[JWileymisc]{as.modelDiagnostics}} and
  \code{\link[JWileymisc]{modelDiagnostics}}.
}
\description{
This function creates a number of diagnostics
for \code{\link[nlme]{lme}} models.
}
\examples{

library(JWileymisc)
sleep[1,1] <- NA
m <- nlme::lme(extra ~ group, data = sleep,
 random = ~ 1 | ID, na.action = "na.omit")

 md <- modelDiagnostics(m, ev.perc = .1)
 md$extremeValues

 plot(md)

data(aces_daily, package = "JWileymisc")
m <- nlme::lme(PosAff ~ STRESS, data = aces_daily,
  random = ~ 1 + STRESS | UserID, na.action = "na.omit")
md <- modelDiagnostics(m, ev.perc = .001)
md$extremeValues
plot(md)


m <- nlme::lme(extra ~ 1, data = sleep, random = ~ 1 | ID/group,
  na.action = "na.omit")

md <- modelDiagnostics(m, ev.perc = .1)
md$extremeValues
plot(md)
rm(m, md, sleep)
}
\keyword{plot}
