% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_plots.R
\name{metrics_plots}
\alias{metrics_plots}
\title{Pairwise metric plots}
\usage{
metrics_plots(
  x,
  raster = NULL,
  classes = NULL,
  radii = NULL,
  c_level = NULL,
  l_level = NULL,
  ext_raster = NULL,
  show_class_names = FALSE,
  upper = TRUE,
  diag = TRUE,
  smooth = TRUE,
  method = "loess",
  se = FALSE,
  st_points = list(shape = 21, size = 2, col = "black", fill = "white", alpha = 1),
  st_lines = list(lty = 1, lwd = 1, col = "black", alpha = 0.6),
  ...
)
}
\arguments{
\item{x}{An object of class 'Multiland' generated with \code{\link[=mland]{mland()}}.}

\item{raster, ext_raster, classes, radii, l_level, c_level}{Parameters to subset plots. See Details.}

\item{show_class_names}{logical. Whether to show classes with its previously defined names (if defined)
when generating the 'MultiLand' object (TRUE), or not (FALSE, default).}

\item{upper}{logical. Whether to plot upper-diagonal plots or not. Default TRUE}

\item{diag}{logical. Whether to plot diagonal density plots or not. Default TRUE.}

\item{smooth}{logical. If TRUE (default) a pattern between the pair of metric values
is plotted, with a smoothing method as defined in \code{method}.}

\item{method}{Smoothing method (function) to use, as in \code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}}. It accepts
"loess" (default), "lm", "gam", among others. See ?ggplot2::geom_smooth() for more details.}

\item{se}{logical. Whether to show (TRUE) or not (FALSE) confidence intervals when \code{smooth = TRUE}.}

\item{st_points}{List of aesthetic arguments for points plotting:
\code{shape} for points shape, \code{size} for points size, \code{col} for
points border color, \code{fill} for points fill color and \code{alpha} for point transparency.}

\item{st_lines}{List of aesthetic arguments for lines plotting (if \code{smooth = TRUE}):
\code{lty} for linetype, \code{lwd} for linewidth,
\code{col} for line color and \code{alpha} for line transparency.}

\item{...}{Other parameters to be passed to \code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}}, if \code{smooth = TRUE}.}
}
\value{
A panel with several plots returned by \code{\link[GGally:ggpairs]{GGally::ggpairs()}} relating pair of metrics
values. Metrics
names are presented at the top and right of the panel (strips), with the following format:
"level"\emph{"metric_name"}"radius". For a landscape-level metric, a plausible metric name could be
"l_np_1500" indicating a landscape-level metric, which is "np" ("number of patches") at a scale
(radius) of 1500 m. For a class-level metric a plausible metric name could be "c4_pland_1000",
indicating a class-level metric of class 4 (the value of the raster), which is "pland"
("percentage of landscape") at a scale (radius) of 1000 m. If more that one rasterlayer is
being analyzed, the prefix "r1", "r2", "r3", ..., "rn" (referring to rasterlayer 1, 2, 3, ..., n) is
added to the metric name.
}
\description{
Plots pair of metric values in two-dimensional plots.
}
\details{
\code{\link[=metrics_plots]{metrics_plots()}} mainly relies on \code{\link[GGally:ggpairs]{GGally::ggpairs()}} to generate pair plots
between metrics values. Arguments \code{upper} and \code{diag} are specific arguments of
\code{\link[GGally:ggpairs]{GGally::ggpairs()}}, here adapted to the context of continuous values only.

Argument \code{raster}, \code{classes}, \code{radii}, \code{l_level} and \code{c_level} can be defined to
subset the plots. In each one of these, an all-positive or an
all-negative vector can be passed, whether to include (all-positive) or exclude (all-negative)
the elements to be taken into account for the subsetting:
\itemize{
\item rasterlayers: a numeric vector with the number of the raster layers to be included/excluded.
For example: \code{c(1, 2, 4)} to include raster layers 1, 2 and 4; \code{c(-2, -3)} to exclude raster layers 2
and 3.
\item classes: must be a list with as many elements as defined raster layers in argument
\code{raster}. Each element of the list must be a numeric vector (classes identities) with the
classes to be included/excluded. If provided a character vector, \code{\link[=metrics_corr]{metrics_corr()}} assumes that
classes names are provided. For example, for the case with 2 raster layers:
\code{list(c(3, 20, 35), c("Forest", "Crops"))} would include classes 3, 20 and 35 from raster layer 1
and classes "Forest" and "Crops" for raster layer 2. For the case of a unique raster layer, there
is no need to input a list. For example, for the case of a unique raster layer and the
exclusion of some classes: \code{c(-5, -10, -15)} to exclude classes 5, 10 and 15 of
the unique raster layer; \code{c("-Forest", "-Grassland")} to exclude classes "Forest" and "Grassland".
Note the "-" before each class name to indicate the exclusion of the classes.
\item radii: a numeric vector to include/exclude particular radii. For example: c(1000, 2000) to
include only radii of 1000 and 2000 m; c(-500, -1500) to exclude radii of 500 and 1500 m.
\item c_level: character vector with the class-level metrics to be included/excluded from
the analysis. For example: \code{c("np", "pland")} will include only the metrics "number of patches"
("np") and "percentage of the landscape" ("pland") in the analysis, whereas \code{c("-np", "-pland")}
will exclude them. Note the "-" before each metric name to indicate the exclusion of the
metrics.
\item l_level: character vector with the landscape-level metrics to be included/excluded from
the analysis. Other calculations for extra raster layers are considered as landscape-level metrics,
and must be provided as "fun_" + the name of the function (e.g. "fun_mean").
}

Names of the available metrics of the 'MultiLandMetrics' object provided in \code{x} can
be accessed with \code{x@metrics} and \code{x@ext_calc}.

Note that patch-level metrics, if exists in \code{x} metric's data.frame, are excluded from
calculations, as this function works at a landscape scale.
}
\examples{
# Pair plots between metrics "pland" of classes 1 to 4, for radius 3000 m
metrics_plots(ed_metrics, classes = 1:4, radii = 3000, show_class_names = TRUE,
              c_level = "pland")

# Without smooth pattern
metrics_plots(ed_metrics, classes = 1:4, radii = 3000, show_class_names = TRUE,
              c_level = "pland", smooth = FALSE)

\donttest{
# Changing aesthetics
metrics_plots(ed_metrics, classes = 1:4, radii = 3000, show_class_names = TRUE,
              c_level = "pland", smooth = FALSE, size = 1.5, shape = 21,
              fill = "red", alpha = 0.4)

# Assessing two radii values at the same time
metrics_plots(ed_metrics, classes = 1:4, radii = c(1000, 5000),
              show_class_names = TRUE, c_level = "pland", smooth = FALSE,
              size = 1.5, shape = 21, fill = "red", alpha = 0.4)

# An example with hundreds of points
metrics_plots(otf_metrics, classes = c("Forest", "Crops"))

# Plots can be combined with ggplot2::theme
metrics_plots(otf_metrics, classes = c("Forest", "Crops")) +
  ggplot2::theme_bw()
}
}
\seealso{
\code{\link[=mland_metrics]{mland_metrics()}}, \code{\link[=metrics_corr]{metrics_corr()}}
}
