% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kernel.R
\name{plot_kernel}
\alias{plot_kernel}
\title{Plot kernel densities}
\usage{
plot_kernel(
  prob = 0.9,
  sigma,
  beta = NULL,
  kernel,
  scale_dist = TRUE,
  add_label = TRUE,
  ...
)
}
\arguments{
\item{prob}{Cumulative kernel density to identify scale of effect distance, Default: 0.9}

\item{sigma}{Value of scaling parameter, sigma}

\item{beta}{Numeric. Shape parameter for exponential power kernel. Ignored unless kernel = "expow". Values between 1-50 are typically valid. (Default = NULL)}

\item{kernel}{Kernel function to use. Valid functions are c('exp', 'gaussian', fixed', 'expow'). See details}

\item{scale_dist}{Logical. If TRUE (Default), the distance at which the specified density probability is achieved is added to the plot along with 95\% confidence interval}

\item{add_label}{Logical. If TRUE (Default), the distance value calculated for 'scale_dist' is added as an annotation to the plot.}

\item{...}{Not used}
}
\value{
ggplot2 objects of kernel density distributions
}
\description{
Generic function to plot kernels
}
\details{
This function is used to visualize kernel density distributions without having a fitted multiScaleR optimized object. Requires (1) sigma, (2) beta (if using exponential power), and (3) the kernel transformation ('exp' = negative exponential, 'gaussian', 'fixed' = fixed buffer, and 'expow' = exponential power)
}
\examples{
#' ## General use of plot method
plot_kernel(prob = 0.95,
            sigma = 100,
            kernel = 'gaussian')
plot_kernel(prob = 0.95,
            sigma = 100,
            kernel = 'exp')
plot_kernel(prob = 0.95,
            sigma = 100,
            kernel = 'fixed')
plot_kernel(prob = 0.95,
            sigma = 100,
            beta = 2.5,
            kernel = 'expow')
}
