% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_main.R
\name{md_merge}
\alias{md_merge}
\title{Merge multiple simulation outputs}
\usage{
md_merge(...)
}
\arguments{
\item{...}{One or more objects of class \code{movedesign_preprocess},
typically generated by \code{\link[=md_run]{md_run()}}. Each object must contain, at
minimum, the elements \code{simList}, \code{simfitList}, and \code{seedList}.
Optional elements such as \code{akdeList} and \code{ctsdList}
are merged if present.}
}
\value{
A single \code{movedesign_output} object that contains all merged
simulation outputs and inherits metadata from the first input
object. The output includes:
\itemize{
\item Merged list of simulated individuals (\code{simList}),
\item Merged list of fitted models (\code{simfitList}),
\item Merged list of seeds used for each simulation replicate
(\code{seedList}),
\item Optionally, merged home range (\code{akdeList}) and
speed (\code{ctsdList}) outputs,
\item Relevant metadata describing the study design parameters.
}
}
\description{
Merges the results of multiple simulation runs, each produced by
\code{\link[=md_run]{md_run()}}, into a single unified \code{movedesign_output} object. This
is especially useful when running replicate simulations for power
analyses, sensitivity testing, or batch processing. Merging allows
you to aggregate all simulated individuals, outputs, and related
metadata, enabling streamlined downstream analyses.
}
\examples{
if (interactive()) {
  input <- md_prepare(
    data = buffalo,
    models = models,
    species = "buffalo",
    n_individuals = 5,
    dur = list(value = 1, unit = "month"),
    dti = list(value = 1, unit = "day"),
    add_individual_variation = TRUE,
    grouped = FALSE,
    set_target = "hr",
    which_meta = "mean"
  )

  output1 <- md_run(input)
  output2 <- md_run(input)

  merged <- md_merge(output1, output2)
}

}
\seealso{
\code{\link{md_prepare}},
\code{\link{md_run}}
}
